{+//____________________________________________________________________________ }
{-Copyright (C) 1996-1998 Pretty Good Privacy, Inc. }
{-All rights reserved. }

{-$Id: Pgprecip.pas,v 1.5.12.2 1999/08/27 22:00:48 build Exp $ }
{=____________________________________________________________________________ }
unit PGPRECIP;

interface
Uses WinTypes,pgpBase,pgpPubtypes,pgpkeys,pgptls,
     WinProcs;




{+// PGPrecip: }
{------------- }

{-There have been a number of modifications to }
{-the API of the recipient dialog for PGP 5.5. }

{-Foremost is the use of KeySetRefs. You must give }
{-the recipient dialog the KeySetRef you wish to }
{-select keys from in OriginalKeySetRef. This is usually }
{-from a PGPOpenDefaultKeyRings call. The keys that }
{-the user actually selects are placed in SelectedKeySetRef }
{-which can be initialized to zero before the call. }
{-This KeySetRef can then be used as an PGPOEncryptToKeySet }
{-option etc. }

{-Second is the use of a char ** array instead of }
{-the older string with \n's (Viacrypt format). Each }
{-pointer in the array points to a null terminated }
{-string containing the recipient as given by the }
{-email client or other application. The recipient }
{-dialog will then attempt to match that name to }
{-a key on startup. }

{-Third, all PGPrecip specific flags are gone. Instead }
{-the flags used by the PGPcmdlg.dll's passphrase dialogs }
{-are used. These flags are divided between option, }
{-disable, and flag fields to facilitate easy passing }
{-from the recipient dialog to the passphrase dialog, }
{-since usually both will be used in tandom. Before, }
{-messy logic was needed to convert the flags from }
{-one calling convention to another. }

{-The flags are contained in PGPcmdlg.h, but are listed here }
{-in commented form for reference: }

{/// options bits }
//*Const PGPCOMDLG_ASCIIARMOR = $0001;
{-Mark the Text Output option. }
//*Const PGPCOMDLG_DETACHEDSIG = $0002;
{-Not used in Recipient Dialog, but may be }
{-passed through as part of passphrase dialog }
{-call }
//*Const PGPCOMDLG_PASSONLY = $0004;
{-Euphanism for conventional encryption }
//*Const PGPCOMDLG_WIPEORIG = $0008;
{-Delete the file after encrypting it. }

{/// disable bits }
//*Const PGPCOMDLG_DISABLE_ASCIIARMOR = $0001;
{-Don't allow user to change Text Output option }
//*Const PGPCOMDLG_DISABLE_AUTOMODE = $0002;
{-_Always_ pop recipient dialog (don't run silent) }
//*Const PGPCOMDLG_DISABLE_PASSONLY = $0004;
{-Don't allow user to change Passphrase only option }
//*Const PGPCOMDLG_DISABLE_WIPEORIG = $0008;
{-Don't allow user to change Wipe Original option }

{/// flag bits }
//Const PGPCOMDLG_RSAENCRYPT = $0001;
{-Used for communication between passphrase dialog }
{-and recipient dialog. Should be initialized to }
{-zero before calling either, and not messed with }
{-except to pass between the two. (This flag lets }
{-us know if we are encrypting to an RSA key and need }
{-a warning when signing with DSS) }

{-Finally, when calling the recipient dialog, always }
{-set the Version field equal to CurrentPGPrecipVersion. }
{-This ensures that incompatible recipientdialogs }
{-aren't used interchangably. }

{-7/11/97 wjb@pgp.com }
{= }

Const CurrentPGPrecipVersion = 'DUKE';
        curver=CurrentPGPrecipVersion;

Type recipientdialogstruct = record
                                Version:dword;
                                hwndParent: HWND;
                                szTitle: PChar;
                                Context: PGPCONTEXTREF;
                                OriginalKeySetRef: PGPKEYSETREF;
                                SelectedKeySetRef: PGPKEYSETREF;
                                szRecipientArray: pPChar;
                                dwNumRecipients: dword;
                                dwOptions: dword;
                                dwFlags: dword;
                                dwDisableFlags:dword;
                                {$IFDEF PGP6}
                                 tlsContext: PGPTLSCONTEXTREF;
                                AddedKeys: PGPKEYSETREF;
                                {$ENDIF}
                              end {_recipientdialogstruct};


PRECIPIENTDIALOGSTRUCT = ^RECIPIENTDIALOGSTRUCT;
{$IFDEF PGP6}
function PGPclRecipientDialog(prds: PRECIPIENTDIALOGSTRUCT): integer; cdecl; far;
{$ELSE}
function PGPRecipientDialog(prds: PRECIPIENTDIALOGSTRUCT): Word; cdecl; far;
{$ENDIF}



implementation
{$IFDEF PGP6}
function PGPclRecipientDialog; external pgpclfile;
{$ELSE}
function PGPRecipientDialog; external  'pgp55rd.dll' ;
{$ENDIF}



end.
