unit PGPSDKPREFS;

interface
Uses WinTypes,
     WinProcs,
     {pgpConfig;}
     pgpBase,
     pgppubtypes;


{+//____________________________________________________________________________ }
{-Copyright (C) 1997 Pretty Good Privacy, Inc. }
{-All rights reserved. }



{-$Id: Pgpsdkprefs.pas,v 1.5.12.2 1999/08/27 22:00:49 build Exp $ }
{=____________________________________________________________________________ }

type
PGPSDKPREFSELECTOR=pgpint32;


const
kPGPsdkPref_First = 0;
kPGPsdkPref_PublicKeyring = kPGPsdkPref_First;
kPGPsdkPref_PrivateKeyring=1;
kPGPsdkPref_RandomSeedFile=2;
kPGPsdkPref_DefaultKeyID=3;
kPGPsdkPref_LastPlusOne=4;


{+// call this if you want the CDK to use prefs stored in the prefs file */ }

function PGPsdkLoadPrefs(context: PGPCONTEXTREF;
                         prefSpec: PGPFILESPECREF): PGPERROR; cdecl;

function PGPsdkLoadDefaultPrefs(context: PGPCONTEXTREF): PGPERROR; cdecl;

{+// save any changed preferences to disk */ }

function PGPsdkSavePrefs(context: PGPCONTEXTREF): PGPERROR; cdecl;



function PGPsdkPrefSetFileSpec(context: PGPCONTEXTREF;
                               selector: PGPSDKPREFSELECTOR;
                               ref: PGPCONSTFILESPECREF): PGPERROR; cdecl;

{+// caller must deallocate *outRef with PGPFreeFileSpec */ }

function PGPsdkPrefGetFileSpec(context: PGPCONTEXTREF;
                               selector: PGPSDKPREFSELECTOR;
                               var outRef: PGPFILESPECREF): PGPERROR; cdecl;



function PGPsdkPrefSetData(context: PGPCONTEXTREF;
                           selector: PGPSDKPREFSELECTOR;
                           Const data: Pointer;
                           size: PGPSIZE): PGPERROR; cdecl;

{+// caller must deallocate *dataOut with PGPFreeData */ }

function PGPsdkPrefGetData(context: PGPCONTEXTREF;
                           selector: PGPSDKPREFSELECTOR;
                           var dataOut: Pointer;
                           var sizeOut: PGPSIZE): PGPERROR; cdecl;


implementation
function PGPsdkLoadPrefs; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPsdkLoadDefaultPrefs; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPsdkSavePrefs; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPsdkPrefSetFileSpec; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPsdkPrefGetFileSpec; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPsdkPrefSetData; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPsdkPrefGetData; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};



end.
