unit PGPSYMMETRICCIPHER;

interface
Uses WinTypes,
     WinProcs,
     pgpPubTypes,
     pgpBase;



{+//____________________________________________________________________________ }
{-pgpSymmetricCipher.h }

{-Copyright (C) 1997 Pretty Good Privacy, Inc. }
{-All rights reserved. }

{-public header file for symmetric ciphers }

{-$Id: Pgpsymmetriccipher.pas,v 1.5.12.2 1999/08/27 22:00:49 build Exp $ }
{=____________________________________________________________________________ }


{+//____________________________________________________________________________ }
{-Create a new cipher of the specified algorithm. Cannot be used until }
{-PGPSetSymmetricCipherKey() has been called. }

{-If the algorithm is not available then kPGPError_AlgorithmNotAvailable is }
{-returned. }

{-most algorithms have only one key size. }
{-Pass 'kPGPSymmetricCipherDefaultKeySize' for these algorithms. }
{=____________________________________________________________________________ }

function PGPNewSymmetricCipher({$IFDEF PGP6}
                                       memoryMgr:pointer;
                               {$ELSE}
                               context: PGPCONTEXTREF;
                               {$ENDIF}
                               algorithm: PGPCIPHERALGORITHM;
                               keySize: PGPUINT32;
                               var outRef: PGPSYMMETRICCIPHERCONTEXTREF): PGPERROR; cdecl;


{+//____________________________________________________________________________ }
{-Disposal clears all data in memory before releasing it. }
{=____________________________________________________________________________ }

function PGPFreeSymmetricCipher(ref: PGPSYMMETRICCIPHERCONTEXTREF): PGPERROR; cdecl;


{+//____________________________________________________________________________ }
{-Make an exact copy of the cipher, including the key. }
{=____________________________________________________________________________ }

function PGPCopySymmetricCipher(ref: PGPSYMMETRICCIPHERCONTEXTREF;
                                var outRef: PGPSYMMETRICCIPHERCONTEXTREF): PGPERROR; cdecl;


{+//____________________________________________________________________________ }
{-The key must be set before using; a cipher can be repeatedly reset and }
{-reused with different keys to avoid having to create and destroy new }
{-contexts each time (and it's also cryptographically better not to reuse }
{-a key). }

{-kKey size is implicit based on algorithm. 'key' is *copied*. Caller }
{-may want to destroy the original after passing it in. }
{=____________________________________________________________________________ }

function PGPInitSymmetricCipher(ref: PGPSYMMETRICCIPHERCONTEXTREF;
                                var key: PGPBYTE): PGPERROR; cdecl;

{+//____________________________________________________________________________ }
{-Wipe any sensitive data in the cipher. Cipher remains alive, but }
{-key must be set before any data is encrypted. }
{=____________________________________________________________________________ }

function PGPWipeSymmetricCipher(ref: PGPSYMMETRICCIPHERCONTEXTREF): PGPERROR; cdecl;


{+//____________________________________________________________________________ }
{-"Wash" the symmetric cipher }
{=____________________________________________________________________________ }

function PGPWashSymmetricCipher(ref: PGPSYMMETRICCIPHERCONTEXTREF;
                                var buf: PGPBYTE;
                                len: PGPUINT32): PGPERROR; cdecl;


{+//____________________________________________________________________________ }
{-Encrypt or decrypt one "block" of data. The block size is determined }
{-by the cipher (see PGPGetSymmetricCipherBlockSize()). }
{=____________________________________________________________________________ }

function PGPSymmetricCipherEncrypt(ref: PGPSYMMETRICCIPHERCONTEXTREF;
                                   var inv: PGPBYTE;
                                   var outv: PGPBYTE): PGPERROR; cdecl;


function PGPSymmetricCipherDecrypt(ref: PGPSYMMETRICCIPHERCONTEXTREF; 
                                   var inv: PGPBYTE;
                                   var outv: PGPBYTE): PGPERROR; cdecl;




{+//____________________________________________________________________________ }
{-Determine key and block size for specified algorithm. Stateless routine }
{-does not need a context. }
{=____________________________________________________________________________ }

function PGPGetSymmetricCipherSizes(ref: PGPSYMMETRICCIPHERCONTEXTREF;
                                    var keySize: PGPUINT32;
                                    var blockSize: PGPUINT32): PGPERROR; cdecl;





implementation

function PGPNewSymmetricCipher; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPFreeSymmetricCipher; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPCopySymmetricCipher; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPInitSymmetricCipher; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPWipeSymmetricCipher; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPWashSymmetricCipher; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPSymmetricCipherEncrypt; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPSymmetricCipherDecrypt; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetSymmetricCipherSizes; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};



end.
