unit PGPUTIL;

{+//____________________________________________________________________________ }
{-pgpUtilities.h }

{-Copyright (C) 1997 Pretty Good Privacy, Inc. }
{-All rights reserved. }

{-This file contains miscellaneous utility functions needed for the PGPsdk. }

{-$Id: Pgputil.pas,v 1.5.12.2 1999/08/27 22:00:49 build Exp $ }
{=____________________________________________________________________________ }

{$IFNDEF Included_pgpUtilities_h /* [ */}
{$DEFINE Included_pgpUtilities_h}

{$IFDEF PGP_MACINTOSH /* [ */}
{$INCLUDE <Files.h>}
{$ENDIF /* ] PGP_MACINTOSH */}

{$INCLUDE "pgpPubTypes.h"}

{$INCLUDE <time.h>}


{$IFDEF PRAGMA_ALIGN_SUPPORTED}
{ #pragma options align=mac68k /* [ */ }
{$ENDIF}


{$IFDEF PGP_MACINTOSH /* [ */}

{+// these types are used as strings in pgpMacFileMapping.h */ }
Const kPGPMacFileCreator_Keys = 'pgpK';
Const kPGPMacFileCreator_DecryptedBinary = '????';
Const kPGPMacFileCreator_DecryptedText = 'ttxt';
Const kPGPMacFileCreator_Tools = 'pgpM';

Const kPGPMacFileTypeArmorFile = 'TEXT';
Const kPGPMacFileTypeEncryptedData = 'pgE';
Const kPGPMacFileTypeSignedData = 'pgSF';
Const kPGPMacFileTypeDetachedSig = 'pgDS';
Const kPGPMacFileTypeRandomSeed = 'pgRS';
Const kPGPMacFileTypePrivRing = 'pgRR';
Const kPGPMacFileTypePubRing = 'pgPR';
Const kPGPMacFileTypePref = 'pref';
Const kPGPMacFileTypeExportedKeys = 'TEXT';
Const kPGPMacFileTypeDecryptedText = 'TEXT';
Const kPGPMacFileTypeDecryptedBinary = 'BINA';

{$ENDIF /* ] PGP_MACINTOSH */}

{ #pragma import on }
{$ENDIF}

{+//____________________________________________________________________________ }
{-Context routines }
{=____________________________________________________________________________ }

Type _1 = (kPGPMemoryFlags_Clear {= 1 } );

Type PGPMemoryFlags = PGPFLAGS;


Type  = VOID *( *PGPMEMORYALLOCATIONPROC)( PGPCONTEXTREF CONTEXT, PGPSIZE ALLOCATIONSIZE, PGPMEMORYFLAGS FLAGS, PGPUSERVALUE USERVALUE );

Type  = PGPERROR ( *PGPMEMORYREALLOCATIONPROC)( PGPCONTEXTREF CONTEXT, VOID **ALLOCATION, PGPSIZE NEWALLOCATIONSIZE, PGPMEMORYFLAGS FLAGS, PGPUSERVALUE USERVALUE );

Type  = PGPERROR ( *PGPMEMORYDEALLOCATIONPROC)( PGPCONTEXTREF CONTEXT, VOID *ALLOCATION, PGPUSERVALUE USERVALUE );


{+//____________________________________________________________________________ }
{-API version: }
{-Top byte is major, next 3 nibbles minor, next 2 bug fix, }
{-last nibble reserved: 0xMMmmmrrR }

{-example: 1.0.0 = 0x01000000 }

{-0x01000000 SDK 1.0.0 }
{-0x02000000 SDK 1.1.0 }
{-0x02000010 SDK 1.1.1 }
{=____________________________________________________________________________ }
Const kPGPsdkAPIVersion = ( (PGPUInt32)0x02000010 );
Const PGPMajorVersion( = v ) ( ( ((PGPUInt32)(v)) & 0xFF000000 ) >> 24 );
Const PGPMinorVersion( = v ) ( ( ((PGPUInt32)(v)) & 0x00FFF000 ) >> 16 );
Const PGPRevVersion( = v ) ( ( ((PGPUInt32)(v)) & 0x00000FF0 ) >> 4 );


Type PGPNewContextStruct = record
{+// sizeofStruct must be inited to sizeof( PGPNewContextStruct ) */ }
                             sizeofStruct: PGPUINT32;
                             allocProc: PGPMEMORYALLOCATIONPROC;
                             reallocProc: PGPMEMORYREALLOCATIONPROC;
                             deallocProc: PGPMEMORYDEALLOCATIONPROC;
                             allocUserValue: PGPUSERVALUE;
                           end {PGPNewContextStruct};



{+// always pass kPGPsdkVersion */ }

function PGPNewContext(clientAPIVersion: PGPUINT32; 
                       newContext: PPGPCONTEXTREF): PGPERROR; cdecl; far;

function PGPNewContextCustom(clientAPIVersion: PGPUINT32; 
                             Const custom: PPGPNEWCONTEXTSTRUCT; 
                             newContext: PPGPCONTEXTREF): PGPERROR; cdecl; far;


function PGPFreeContext(context: PGPCONTEXTREF): PGPERROR; cdecl; far;


function PGPGetContextUserValue(context: PGPCONTEXTREF; 
                                userValue: PPGPUSERVALUE): PGPERROR; cdecl; far;

function PGPSetContextUserValue(context: PGPCONTEXTREF; 
                                userValue: PGPUSERVALUE): PGPERROR; cdecl; far;


function PGPContextGetRandomBytes(context: PGPCONTEXTREF; 
                                  buf: Pointer; 
                                  len: PGPSIZE): PGPERROR; cdecl; far;


{+//____________________________________________________________________________ }
{-Memory allocation }

{-The PGPsdk uses PGPNewData() for allocated return parameters. }
{-Clients should use PGPFreeData() to deallocate memory allocated with }
{-PGPNewData(). }

{-PGPNewData should generally not be used by clients (there are a few }
{-special cases). }

{-PGPNewSecureData is intended to store sensitive data such as passphrases. }
{=____________________________________________________________________________ }


procedure PGPNewData(context: PGPCONTEXTREF; 
                     allocationSize: PGPSIZE); cdecl; far;

{+// 'didLock' is TRUE if the memory is guaranteed to not be paged */ }
{+// Some OSes don't support this feature */ }

procedure PGPNewSecureData(context: PGPCONTEXTREF; 
                           allocationSize: PGPSIZE; 
                           didLock: PPGPBOOLEAN); cdecl; far;

{+// can free allocation from PGPNewData or PGPNewSecureData */ }

procedure PGPFreeData(allocation: Pointer); cdecl; far;


{+//____________________________________________________________________________ }
{-FileRefs }
{=____________________________________________________________________________ }


function PGPCopyFileSpec(fileRef: PGPCONSTFILESPECREF; 
                         ref: PPGPFILESPECREF): PGPERROR; cdecl; far;

function PGPFreeFileSpec(fileRef: PGPFILESPECREF): PGPERROR; cdecl; far;

{$IFDEF PGP_MACINTOSH /* [ */}


function PGPNewFileSpecFromFSSpec(context: PGPCONTEXTREF; 
                                  Const spec: PFSSPEC; 
                                  ref: PPGPFILESPECREF): PGPERROR; cdecl; far;

function PGPGetFSSpecFromFileSpec(fileRef: PGPCONSTFILESPECREF; 
                                  spec: PFSSPEC): PGPERROR; cdecl; far;
{$ELSE}


function PGPNewFileSpecFromFullPath(context: PGPCONTEXTREF; 
                                    Const path: PChar; 
                                    ref: PPGPFILESPECREF): PGPERROR; cdecl; far;

{+// *fullPathPtr ***must*** be freed with PGPFreeData */ }

function PGPGetFullPathFromFileSpec(fileRef: PGPCONSTFILESPECREF; 
                                    fullPathPtr: PPChar): PGPERROR; cdecl; far;

{$ENDIF /* ] PGP_MACINTOSH */}



{+//____________________________________________________________________________ }
{-Time }
{=____________________________________________________________________________ }

function PGPGetTime: PGPTIME; cdecl; far;

{+// these use time_t type as returned by time() in Std C libraries */ }

function PGPGetStdTimeFromPGPTime(theTime: PGPTIME): TIME_T; cdecl; far;

function PGPGetPGPTimeFromStdTime(theTime: TIME_T): PGPTIME; cdecl; far;


{+// year, month, day may be NULL if desired */ }

procedure PGPGetYMDFromPGPTime(theTime: PGPTIME; 
                               year: PPGPUINT16; 
                               month: PPGPUINT16; 
                               day: PPGPUINT16); cdecl; far;


{$IFDEF PGP_MACINTOSH /* [ */}

function PGPTimeToMacTime(theTime: PGPTIME): PGPUINT32; cdecl; far;

function PGPTimeFromMacTime(theTime: PGPUINT32): PGPTIME; cdecl; far;
{$ENDIF /* ] PGP_MACINTOSH */}



{+//____________________________________________________________________________ }
{-MacBinary support }
{=____________________________________________________________________________ }


{+//____________________________________________________________________________ }
{-Examine the input file to see if it's a MacBinary file. If it is }
{-not a MacBinary file, then the original file is unaltered. }
{-Otherwise, the file is converted and the original file is deleted. }

{-The resulting file is designated by 'outPGPSpec' and may have a different }
{-name than the original. }

{-If the file is a TEXT file, appropriate line-end conversion is done. }

{-creator and type code pointers may be }
{-null but otherwise contain the mac creator and type. }

{-This routine can be called on a Mac, but generally doesn't need to be. }
{=____________________________________________________________________________ }

function PGPMacBinaryToLocal(inSpec: PGPFILESPECREF; 
                             outSpec: PPGPFILESPECREF; 
                             macCreator: PPGPUINT32; 
                             macTypeCode: PPGPUINT32): PGPERROR; cdecl; far;




{+//____________________________________________________________________________ }
{-Call PGPsdkInit() before using the SDK. Call PGPsdkCleanup() when you are }
{-done (but after disposing of any PGPContexts). }

{-You may call multiple times (with no effect), but be sure to call }
{-PGPsdkCleanup() for each call to PGPsdkInit(). }
{=____________________________________________________________________________ }

function PGPsdkInit: PGPERROR; cdecl; far;

function PGPsdkCleanup: PGPERROR; cdecl; far;

{$IFDEF PRAGMA_IMPORT_SUPPORTED}
{ #pragma import reset }
{$ENDIF}


{$IFDEF PRAGMA_ALIGN_SUPPORTED}
{ #pragma options align=reset /* ] */ }
{$ENDIF}

{$ENDIF /* ] Included_pgpUtilities_h */}

{+//__Editor_settings____ }

{-Local Variables: }
{-tab-width: 4 }
{-End: }
{-vi: ts=4 sw=4 }
{-vim: si }
{=_____________________ }

implementation
{$IFNDEF Included_pgpUtilities_h /* [ */}
{$DEFINE Included_pgpUtilities_h}
{$IFDEF PGP_MACINTOSH /* [ */}
{$INCLUDE <Files.h>}
{$ENDIF /* ] PGP_MACINTOSH */}
{$INCLUDE "pgpPubTypes.h"}
{$INCLUDE <time.h>}
{$IFDEF PRAGMA_ALIGN_SUPPORTED}
{$ENDIF}
{$IFDEF PGP_MACINTOSH /* [ */}
{$ENDIF /* ] PGP_MACINTOSH */}
{$ENDIF}

function PGPNewContext(clientAPIVersion: PGPUINT32; 
                       newContext: PPGPCONTEXTREF): PGPERROR; external 'PGPUTI~1';

function PGPNewContextCustom(clientAPIVersion: PGPUINT32; 
                             Const custom: PPGPNEWCONTEXTSTRUCT; 
                             newContext: PPGPCONTEXTREF): PGPERROR; external 'PGPUTI~1';

function PGPFreeContext(context: PGPCONTEXTREF): PGPERROR; external 'PGPUTI~1';

function PGPGetContextUserValue(context: PGPCONTEXTREF; 
                                userValue: PPGPUSERVALUE): PGPERROR; external 'PGPUTI~1';

function PGPSetContextUserValue(context: PGPCONTEXTREF; 
                                userValue: PGPUSERVALUE): PGPERROR; external 'PGPUTI~1';

function PGPContextGetRandomBytes(context: PGPCONTEXTREF; 
                                  buf: Pointer; 
                                  len: PGPSIZE): PGPERROR; external 'PGPUTI~1';

procedure PGPNewData(context: PGPCONTEXTREF; 
                     allocationSize: PGPSIZE); external 'PGPUTI~1';

procedure PGPNewSecureData(context: PGPCONTEXTREF; 
                           allocationSize: PGPSIZE; 
                           didLock: PPGPBOOLEAN); external 'PGPUTI~1';

procedure PGPFreeData(allocation: Pointer); external 'PGPUTI~1';

function PGPCopyFileSpec(fileRef: PGPCONSTFILESPECREF; 
                         ref: PPGPFILESPECREF): PGPERROR; external 'PGPUTI~1';

function PGPFreeFileSpec(fileRef: PGPFILESPECREF): PGPERROR; external 'PGPUTI~1';
{$IFDEF PGP_MACINTOSH /* [ */}

function PGPNewFileSpecFromFSSpec(context: PGPCONTEXTREF; 
                                  Const spec: PFSSPEC; 
                                  ref: PPGPFILESPECREF): PGPERROR; external 'PGPUTI~1';

function PGPGetFSSpecFromFileSpec(fileRef: PGPCONSTFILESPECREF; 
                                  spec: PFSSPEC): PGPERROR; external 'PGPUTI~1';
{$ELSE}

function PGPNewFileSpecFromFullPath(context: PGPCONTEXTREF; 
                                    Const path: PChar; 
                                    ref: PPGPFILESPECREF): PGPERROR; external 'PGPUTI~1';

function PGPGetFullPathFromFileSpec(fileRef: PGPCONSTFILESPECREF; 
                                    fullPathPtr: PPChar): PGPERROR; external 'PGPUTI~1';
{$ENDIF /* ] PGP_MACINTOSH */}

function PGPGetTime: PGPTIME; external 'PGPUTI~1';

function PGPGetStdTimeFromPGPTime(theTime: PGPTIME): TIME_T; external 'PGPUTI~1';

function PGPGetPGPTimeFromStdTime(theTime: TIME_T): PGPTIME; external 'PGPUTI~1';

procedure PGPGetYMDFromPGPTime(theTime: PGPTIME; 
                               year: PPGPUINT16; 
                               month: PPGPUINT16; 
                               day: PPGPUINT16); external 'PGPUTI~1';
{$IFDEF PGP_MACINTOSH /* [ */}

function PGPTimeToMacTime(theTime: PGPTIME): PGPUINT32; external 'PGPUTI~1';

function PGPTimeFromMacTime(theTime: PGPUINT32): PGPTIME; external 'PGPUTI~1';
{$ENDIF /* ] PGP_MACINTOSH */}

function PGPMacBinaryToLocal(inSpec: PGPFILESPECREF; 
                             outSpec: PPGPFILESPECREF; 
                             macCreator: PPGPUINT32; 
                             macTypeCode: PPGPUINT32): PGPERROR; external 'PGPUTI~1';

function PGPsdkInit: PGPERROR; external 'PGPUTI~1';

function PGPsdkCleanup: PGPERROR; external 'PGPUTI~1';
{$IFDEF PRAGMA_IMPORT_SUPPORTED}
{$ENDIF}
{$IFDEF PRAGMA_ALIGN_SUPPORTED}
{$ENDIF}
{$ENDIF /* ] Included_pgpUtilities_h */}

end.
