{+//____________________________________________________________________________ }
{-Copyright (C) 1996-1998 Pretty Good Privacy, Inc. }
{-All rights reserved. }

{-$Id: Pgputilities.pas,v 1.5.12.4 1999/09/03 18:25:01 build Exp $ }
{=____________________________________________________________________________ }
unit PGPUTILITIES;

interface
Uses WinTypes,
     WinProcs,
     pgpPubTypes,pgpmemory,
     pgpbase;

Type
PtrPGPCONTEXTREF=^PGPCONTEXTREF;
PGPMemoryFlags = PGPFLAGS;
{+//____________________________________________________________________________ }
{-pgpUtilities.h }

{-Copyright (C) 1996-1998 Pretty Good Privacy, Inc. }
{-All rights reserved. }

{-This file contains miscellaneous utility functions needed for the PGPsdk. }

{-$Id: Pgputilities.pas,v 1.5.12.4 1999/09/03 18:25:01 build Exp $ }
{=____________________________________________________________________________ }




{+//____________________________________________________________________________ }
{-Context routines }
{=____________________________________________________________________________ }



{+// top byte is major, next 3 nibbles minor, last 3 bug fix */ }
{+// version 1.000.000 */ }
{$IFDEF PGP6}
{$ELSE}
PGPMEMORYALLOCATIONPROC = function( context:PGPCONTEXTREF;ALLOCATIONSIZE:pgpsize;FLAGS:PGPMEMORYFLAGS;uservalue: PGPUSERVALUE):pointer;

PGPMEMORYREALLOCATIONPROC=function(CONTEXT: PGPCONTEXTREF;var ALLOCATION:pointer;  NEWALLOCATIONSIZE:PGPSIZE; FLAGS:PGPMEMORYFLAGS; USERVALUE: PGPUSERVALUE):PGPERROR;

PGPMEMORYDEALLOCATIONPROC=function(CONTEXT: PGPCONTEXTREF;ALLOCATION:pointer;USERVALUE:PGPUSERVALUE):PGPERROR;

{$ENDIF}


PGPNewContextStruct = record
{+// sizeofStruct must be inited to sizeof( PGPNewContextStruct ) */ }
                             sizeofStruct: PGPUINT32;
                             {$IFDEF PGP6}
                             memorymgr:PGPMEMORYMGRREF;
                             {$ELSE}
                             allocProc: PGPMEMORYALLOCATIONPROC;
                             reallocProc: PGPMEMORYREALLOCATIONPROC;
                             deallocProc: PGPMEMORYDEALLOCATIONPROC;
                             allocUserValue: PGPUSERVALUE;
                             {$ENDIF}

                           end ;{PGPNewContextStruct}


const
kPGPMemoryFlags_Clear = 1 ;
{$IFDEF PGP6}
Const kPGPsdkAPIVersion =$03000000;
{$ELSE}
Const kPGPsdkAPIVersion =$02000010 ;
{$ENDIF}

const v = kPGPsdkAPIVersion;
Const PGPMajorVersion:PGPUInt32 =(v and $FF000000)  shr 24 ;
Const PGPMinorVersion:PGPUInt32=(v and $00FFF000)  shr 16 ;
Const PGPRevVersion:PGPUInt32= (v and $00000FF0) shr 4 ;

{+// always pass kPGPsdkVersion */ }



function PGPNewContext(clientAPIVersion: PGPUINT32;
                      var newContext: PGPCONTEXTREF): PGPERROR; cdecl;

function PGPNewContextCustom(clientAPIVersion: PGPUINT32;
                             var custom: PGPNEWCONTEXTSTRUCT;
                             var newContext: PGPCONTEXTREF): PGPERROR; cdecl;


function PGPFreeContext(context: PGPCONTEXTREF): PGPERROR; cdecl;


function PGPGetContextUserValue(context: PGPCONTEXTREF;
                                var userValue: PGPUSERVALUE): PGPERROR; cdecl;

function PGPSetContextUserValue(context: PGPCONTEXTREF;
                                userValue: PGPUSERVALUE): PGPERROR; cdecl;


function PGPContextGetRandomBytes(context: PGPCONTEXTREF;
                                  var buf: PGPBYTE;
                                  len: PGPSIZE): PGPERROR; cdecl;

function SendPGPlogMsg(hnd:thandle;szMsg:pchar):integer;cdecl;

{+//____________________________________________________________________________ }
{-Memory allocation }

{-The PGPsdk uses PGPNewData() for allocated return parameters. }
{-Clients should use PGPFreeData() to deallocate memory allocated with }
{-PGPNewData(). }

{-PGPNewData should generally not be used by clients (there are a few }
{-special cases). }
{=____________________________________________________________________________ }

{$IFDEF PGP6}
function PGPGetContextMemoryMgr(context:PGPContextRef ):PGPMEMORYMGRREF;cdecl;
{$ELSE}
function PGPNewData(context: PGPCONTEXTREF;
                     allocationSize: PGPSIZE):pointer; cdecl;

function PGPNewSecureData(context: PGPCONTEXTREF;
                           allocationSize: PGPSIZE;
                           didLock: PPGPBOOLEAN):pointer; cdecl; far;

procedure PGPFreeData(allocation: Pointer); cdecl;
{$ENDIF}

{+// 'didLock' is TRUE if the memory is guaranteed to not be paged */ }
{+// Some OSes don't support this feature */ }





{+//____________________________________________________________________________ }
{-FileRefs }
{=____________________________________________________________________________ }


function PGPCopyFileSpec(fileRef: PGPCONSTFILESPECREF;
                         var ref: PGPFILESPECREF): PGPERROR; cdecl;

function PGPFreeFileSpec(fileRef: PGPFILESPECREF): PGPERROR; cdecl;



function PGPNewFileSpecFromFullPath(context: PGPCONTEXTREF;
                                    Const path: PChar;
                                    var ref: PGPFILESPECREF): PGPERROR; cdecl;

{+// *fullPathPtr ***must*** be freed with PGPFreeData */ }

function PGPGetFullPathFromFileSpec(fileRef: PGPCONSTFILESPECREF;
                                    var fullPathPtr: PChar): PGPERROR; cdecl;



{+//____________________________________________________________________________ }
{-Time }
{=____________________________________________________________________________ }

function PGPGetTime: PGPTIME; cdecl;

{+// these use time_t type as returned by time() in Std C libraries */ }

function PGPGetStdTimeFromPGPTime(theTime: PGPTIME):int64; cdecl;

function PGPGetPGPTimeFromStdTime(theTime: tdatetime): PGPTIME; cdecl;


{+// year, month, day may be NULL if desired */ }

procedure PGPGetYMDFromPGPTime(theTime: PGPTIME;
                               var year: PGPUINT16;
                               var month: PGPUINT16;
                               var day: PGPUINT16); cdecl;





implementation

{$IFDEF PGP6}
function PGPGetContextMemoryMgr; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};
{$ELSE}
function PGPNewData; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPNewSecureData; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

procedure PGPFreeData; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};
{$ENDIF}

function PGPNewContext; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPNewContextCustom; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPFreeContext; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetContextUserValue; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPSetContextUserValue; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPContextGetRandomBytes; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPCopyFileSpec; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPFreeFileSpec; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPNewFileSpecFromFullPath; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetFullPathFromFileSpec; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};


function PGPGetTime; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetStdTimeFromPGPTime; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPGetPGPTimeFromStdTime; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

procedure PGPGetYMDFromPGPTime; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function SendPGPlogMsg; external 'pgpsc.dll';
end.
