{+//____________________________________________________________________________ }
{-Copyright (C) 1996-1998 Pretty Good Privacy, Inc. }
{-All rights reserved. }

{-$Id: Servobj.pas,v 1.6.12.2 1999/08/27 22:00:49 build Exp $ }
{=____________________________________________________________________________ }
unit servobj;

interface

uses
 { comobj,comserv,}pgp2,oleauto, ole2,Windows, C3PO,C3poinc;

type
{***********************************************************
   Object Name:  C3POServer sub classed from TC3POServer.

   Description:  Every C3PO must support this interface.  It is used to
                 initialize the C3PO.

************************************************************}
  C3POServer = class(TC3POServer)
  private
    { Private declarations }
    function GetCmdFact: Variant;
    function GetDescription : string;
    function GetEventMonitor : variant;
    function GetIconFactory : variant;

  automated
    { Automated declarations }
    property CommandFactory : Variant read GetCmdFact;
    property Description: string read GetDescription;
    property EventMonitor: variant read GetEventMonitor;
    property IconFactory: variant read GetIconFactory;
    function CanShutdown: TOleBool;
    procedure Init(Manager: variant);
end;

implementation
var
   g_CommandFactory : CommandFactory;                 // Create global CommandFactory object
   g_IconFactory : IconFactory;                       // Create global IconFactory object
   g_EventMonitor : EventMonitor;                     // Create global EventMonitor object

{***********************************************************
   Name:       C3POServer.GetCmdFact

   Description:  This property returns the CommandFactory for the C3PO.  The
                 C3PO server may return NULL.


   In:           none

   Out:          CommandFactory object or null in not supported

   Comments:

************************************************************}
function C3POServer.GetCmdFact : Variant;
begin
     Result := g_CommandFactory.OleObject;            // Return Ole object g_CommandFactory
end;

{***********************************************************
   Name:         C3POServer.GetDescription

   Description:  Returns a human readable description of the C3PO server.

   In:           none

   Out:          string

   Comments:

************************************************************}
function C3POServer.GetDescription : string;
begin
  Result := 'PGP for Groupwise';                // Return Customer Tracking string description
end;

{***********************************************************
   Name:         C3POServer.GetEventMonitor

   Description:  This property returns the event monitor for the C3PO.  The
                 C3PO server may return NULL.


   In:           none

   Out:          EventMonitor object or null if not supported

   Comments:

************************************************************}
function C3POServer.GetEventMonitor : Variant;
begin
     Result := g_EventMonitor.OleObject;              // return Oleobject g_EventMonitor
end;

{***********************************************************
   Name:       C3POServer.CanShutdown

   Description:  This method is invoked to query whether the C3PO server can
                 shutdown.  Typically, this is used when the C3PO server has a
                 window open on the UI screen and is not in a state where shutdown
                 is possible.  Each C3PO server is guaranteed to have CanShutdown
                 queried at least once before the C3PO system shuts down.

                 Semantically, CanShutdown is a request from the C3POManager to
                 a given C3PO.  It's not a request for shutting down a C3PO as
                 much as it is a request to shutdown the C3POManager and consequently
                 disconnect the C3PO.  Typically, a C3PO would shutdown along
                 with the C3POManager, but this is not strictly required.

                 No particular C3PO order can be relied on for querying the CanShutdown property.

   In:           none

   Out:          TRUE if it is OK to shutdown
                 FALSE if it is not OK to shutdown

   Comments:

************************************************************}
function C3POServer.CanShutdown: TOleBool;
begin
     
     Result := TRUE;                                  // return it is OK to shutdown
end;


{***********************************************************
   Name:       C3POServer.GetIconFactory

   Description:  This property returns the IconFactory for the C3PO.  The C3PO
                 server may return NULL.


   In:           none

   Out:          IconFactory object or null if not supported


   Comments:

************************************************************}
function C3POServer.GetIconFactory : Variant;
begin
    Result := g_IconFactory.OleObject;                // return OleObject g_IconFactory
end;

{***********************************************************
   Name:       C3POServer.Init

   Description:  This method is the first method invoked in the C3POServer object
                 when loading a C3PO server.  If the server fails this call
                 (via the HRESULT), the C3PO server is unloaded.

                 One Init call will be issued to the C3POServer for each C3PO
                 Client using the C3PO system.  C3POs that wish to be capable of
                 loading into multiple Clients (irrespective of process boundaries)
                 should be multiple-instance OLE servers.  That is, a new C3POServer
                 object should be created for each C3POManager that wished to use
                 the services of the C3PO.  By tracking the Manager pointer for
                 each C3POServer, the C3PO can sort out which requests are being
                 issued from which clients.

                 The Manager object is valid until a future DeInit() call.
                 That is, the C3PO does not need to AddRef() this object but can
                 simply store it for the life of the C3PO (until DeInit is called).



   In:           Manager: variant - C3POManager object

   Out:          none

   Comments:

************************************************************}
procedure C3POServer.Init(Manager: variant);
var
   tmpname,parmstr:string;
   lines : integer;
   ini:textfile;
sysdir:array[0..255] of char;
   keyH1,keyH2:Hkey ;
   count,cd,loaded:longint;
   lang:array[0..2] of char;
   len,err:longint;
   tpath,tprog:string;
mess:variant;
begin
GroupWise:=CreateOleObject('NovellGroupWareSession');
Account:=GroupWise.Login;
while form1=nil do
begin
end;

form1.reply:=false;
{$IFDEF GW52}
form1.owneraddress:=account.owner.emailaddress;
{$ELSE}
form1.owneraddress:=getaddress(account.owner.emailaddress);
{$ENDIF}
if pos('$$$',form1.owneraddress)=0 then
begin

form1.SetupFields; //setup the fields
(*if not form1.dontshow then
if not form1.pgp.checkandadd(form1.owneraddress) then //dont show again, if requested
form1.setfield(dontshowaddressfield,true);*)
end;
  c3po.g_C3POManager := Manager;                           // save C3POMonitor object
   end;

{***********************************************************
   Name:       RegisterC3POServer

   Description: This routine registers the C3POServer.

   In:          none

   Out:         none

   Comments:

************************************************************}
procedure RegisterC3POServer;
const
  AutoClassInfo: TAutoClassInfo = (
    AutoClass: C3POServer;
    ProgID: 'PGPGW.C3PO';
    ClassID: '{BE2F27C1-53D3-11CF-AF6C-00A024AFE348}';
    Description: 'PGP for Groupwise C3PO Object';
    Instancing: acMultiInstance);
begin

  Automation.RegisterClass(AutoClassInfo);
{automation.updateregistry(true);} 
end;

{Create OleObjects}
initialization
begin
{     Oleinitialize(nil);}
  RegisterC3POServer;
  g_CommandFactory := CommandFactory.Create;
  g_IconFactory := IconFactory.Create;
  g_EventMonitor := EventMonitor.Create;
end;

{Release OleObjects}
finalization
begin
{oleuninitialize;}
  g_CommandFactory.Release;
  g_IconFactory.Release;
  g_EventMonitor.Release;
end;

end.