{+//____________________________________________________________________________ }
{-Copyright (C) 1996-1998 Pretty Good Privacy, Inc. }
{-All rights reserved. }

{-$Id: wpcom32.pas,v 1.5.12.2 1999/08/27 22:00:51 build Exp $ }
{=____________________________________________________________________________ }
unit wpcom32;

interface
uses
  SysUtils, WinTypes,ddeman, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs,shellapi,comobj{,oleauto};

type
  QueryException=class(Exception);
  TWP = class(TWinControl)
  private
  Commander:variant;
  Fcomret: string;
  ferror:integer;
{  DDES:string;
  DDET:String;}
{  procedure testlink; }
  function getcomret:string;
  procedure setcom(Acom:string);
  function getcommanderror:string;
    { Private declarations }
  protected
    { Protected declarations }
  public
    { Public declarations }
    property CommandString:string write SetCom;
    constructor create(Aowner:Tcomponent); override;
    destructor destroy; override;
    property CommandReturn:string read getcomret;
    property CommandError: string read GetCommandError;
    property IsError: integer read ferror;
    published

    { Published declarations }
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('OCX', [TWP]);
end;


destructor twp.destroy;
begin
commander:=unassigned;
inherited destroy;
end;


function twp.getcomret:string;
begin

{if assigned(fcomret) then
result:=strpas(fcomret) else}
result := fcomret;
end;


constructor twp.create(aowner:tcomponent);
begin
inherited create(aowner);
{commander:=CreateOleObject('GroupWiseCommander');}
commander:=unassigned;
visible:=false;
end;

procedure twp.setcom(Acom:string);

begin
if varisempty(commander) then
commander:=CreateOleObject('GroupWiseCommander');
try
ferror:=commander.execute(acom,fcomret);
except fcomret:='FAIL'; end;
{command:=stralloc(255);
strpcopy(command,acom); }

{executemacro(command,true);
strdispose(command);}
{testlink;
fcomret:=requestdata(acom);}
end;

function twp.getcommanderror:string;
var
error:string;
begin
{testlink;}
commander.execute('envlasterror()',error);
result:=error;
end;

end.

