/*____________________________________________________________________________
	Copyright (C) 2000 Pretty Good Privacy, Inc.
	All rights reserved.


	$Id: LibRichText.h,v 1.10.12.7 2000/08/09 01:23:07 build Exp $
____________________________________________________________________________*/

/*::: FUNCTIONAL OVERVIEW ::::::::::

--- revision history --------
2/23/00 Version 1.2 Paul Ryan
+ changed signature to eus_InsertSubformTop() to accommodate extenstion 
  such that subforms that consist of multiple rich-text items may be inserted 
  by the procedure
+ adjustments made in support of making the PGP Plug-In compatible with the 
  Notes R5 mail template

1/5/99 Version 1.0 Paul Ryan
::::::::::::::::::::::::::::::::::::*/

#ifndef Included_LibRichText_h	/* [ */
#define Included_LibRichText_h


//Notes API includes
#include <easycd.h>		//for COMPOUNDSTYLE
#include <editdflt.h>	//for CDPABDEFINITION defaults like DEFAULT_TABS


#define i_LEN_OPAQUE_RTCURSOR  4
typedef struct	{
	BYTE * puc_location;		//should always point to the beginning of 
					//	a CD record
	WORD  us_recLength;
	BYTE  opaque[ i_LEN_OPAQUE_RTCURSOR];
} RtfCursor;

#define i_LEN_OPAQUE_RTCONTEXT  26
typedef struct	{
	BYTE  opaque[ i_LEN_OPAQUE_RTCONTEXT];
} RtfContext;

typedef struct	{
	RtfCursor  t_cursorBegin;
	WORD  us_offsetBegin;
	RtfCursor  t_cursorEnd;
	WORD  us_offsetEnd;
}  RtfSpan;


extern const DWORD  eul_ERR_FAILURE;

#define mi_MAXLEN_UNIQUE_ATTCNM  128
static const COMPOUNDSTYLE  mt_HIDDEN_PARAGRAPH_DEF = 
								{DEFAULT_JUSTIFICATION, DEFAULT_LINE_SPACING, 
								DEFAULT_ABOVE_PAR_SPACING, 
								DEFAULT_BELOW_PAR_SPACING, 
								DEFAULT_LEFT_MARGIN, DEFAULT_RIGHT_MARGIN, 
								DEFAULT_FIRST_LEFT_MARGIN, DEFAULT_TABS, 
								{DEFAULT_TAB_INTERVAL}, 
								PABFLAG_HIDEBITS & ~PABFLAG_HIDE_IF | 
								DEFAULT_PAGINATION};


STATUS eus_InitializeRtfContext( NOTEHANDLE, char[], RtfCursor *const, 
														RtfContext *const);
BOOL ef_CursorToStringStart( const char[], const BOOL, RtfCursor, const WORD, 
											const RtfContext *const, 
											RtfCursor *const, WORD *const);
STATUS eus_SwapHotspots( RtfCursor *const, RtfCursor, RtfContext *const);
BOOL ef_FreeRtfContext( RtfContext *const);
DWORD eul_GetRtfSpanText( const RtfSpan *const, const DWORD, const BOOL, 
									const RtfContext *const, char * *const);
BOOL ef_CursorToAttachmentHotspot( RtfCursor *const, const RtfContext *const, 
									const BOOL, RtfSpan *const, 
									const char * *const, const char * *const);
STATUS eus_ResetAttachHotspotNames( const char[], const char[], 
										const RtfCursor, RtfContext *const);
DWORD eul_GetRtfText( const RtfContext *const, const DWORD, const BOOL, 
															char * *const);
STATUS eus_ReplaceRtfSpanText( RtfSpan *const, const DWORD, const BOOL, 
										const char[], RtfContext *const);
STATUS eus_CommitChangedRtf( HANDLE, char[], RtfContext *const);
STATUS eus_ReplaceRtfWithStandardText( const char[], const BOOL, 
														RtfContext *const);
STATUS eus_AppendRtParagraph( const WORD, const COMPOUNDSTYLE *const, 
											RtfContext *const, WORD *const);
RtfContext * ept_InitUtilityRtfContext( RtfContext *const);
STATUS eus_AppendItemsToRtf( const RtfContext *const, RtfContext *const);
BOOL ef_UnappendRtfItems( const RtfContext *const, RtfContext *const);
STATUS eus_CopyRtfIntoBuffer( const RtfContext *const, HANDLE *const, 
												DWORD *const, BYTE * *const);
STATUS eus_AppendAttachmentHotspot( NOTEHANDLE, const char[], char[], 
											const BYTE *const, const WORD, 
											RtfContext *const);
STATUS eus_ReplaceRtfWithCdStream( const BYTE *const, const DWORD, 
														RtfContext *const);
STATUS eus_RemoveRtSpan( const RtfSpan *const, RtfContext *const);
STATUS eus_InsertTextAtHotspotEnd( const char *const, const RtfCursor, 
														RtfContext *const);
BOOL ef_RenumberPgraphStylesToSpan( const WORD, const WORD, RtfCursor, 
													const RtfContext *const);
BOOL ef_FindPgraphStyleUnusedSpan( const WORD, RtfCursor, 
													const RtfContext *const, 
													WORD *const, BOOL *const);
BOOL ef_GetPgraphStyleCount( RtfCursor, const RtfContext *const, WORD *const);
STATUS eus_InsertSubformTop( RtfContext *const, RtfContext *const, 
																const char[]);
STATUS eus_AddRtfActualContext( NOTEHANDLE, char[], RtfContext *const);
STATUS eus_CopyRtfContent( RtfContext *const, const BOOL, RtfContext *const);


#endif /* ] Included_LibRichText_h */
