/*____________________________________________________________________________
	Copyright (C) 1999 Pretty Good Privacy, Inc.
	All rights reserved.
	

	$Id: ObjectHandling.c,v 1.8.8.1.2.9 2000/08/09 01:23:08 build Exp $
____________________________________________________________________________*/

/*::: MODULE OVERVIEW :::::::::::::

--- revision history --------
9/12/99: Version 1.1: Paul Ryan
+ genericization, documentation of eus_getObjectContentsInBuffer()

12/10/98 Version 1.0: Paul Ryan
::::::::::::::::::::::::::::::::::::*/

#include "ObjectHandling.h"


//global-scope declaration
char  epc_ITEMNM_STANDARD_ATTACH[] = ITEM_NAME_ATTACHMENT;

//module-scope declaration
#define mus_MAXBUF_EXTFILENM  255


/** us_AttachObjectItem( ***


--- parameters & return ----

RETURN: eus_SUCCESS if no error occured; the Notes API error code otherwise

--- revision history -------
1/30/99 PR: created			*/
//DOC!!
static STATUS us_AttachObjectItem( NOTEHANDLE  h_NOTE, 
									const DWORD  ul_OBJ_ID, 
									char  pc_ITMNM[], 
									const char  pc_OBJNM[], 
									const DWORD  ul_OBJ_SIZE, 
									const WORD  us_HOST_TYPE)	{
	const char * pc_objNm;
	BLOCKID  bid;
	WORD * pus, us_lenItem;
	TIMEDATE  td;
	FILEOBJECT * pt_itmInfo;
	WORD  us;
	STATUS  us_error;

	if (!( h_NOTE && ul_OBJ_ID && pc_ITMNM && pc_OBJNM && ul_OBJ_SIZE))
		return !eus_SUCCESS;

	if (!( pc_objNm = strrchr( pc_OBJNM, ec_PATH_SPECIFIER)))
		pc_objNm = pc_OBJNM;
	//else step to the character immediately after the last backslash 
	else
		pc_objNm++;

	if (us_error = OSMemAlloc( NULL, us_lenItem = sizeof( WORD) + sizeof( 
											FILEOBJECT) + (us = (WORD) 
											strlen( pc_objNm)), &bid.pool))
		return us_error;
	bid.block = NULLBLOCK;

	pus = OSLockBlock( WORD, bid);
	*pus = TYPE_OBJECT;

	//Fill in the item structure used to describe the object to the note 
	//	"hosting" the object. A host type of "MSDOS" in needed in order to 
	//	ensure that the object travels with the rich-text field when the 
	//	message is forwarded or replied to "with history" ("unkown" works 
	//	as well). I'm not sure what the "in-doc" flag does, but Notes seems 
	//	to put it on every attachment, so we will too.
	pt_itmInfo = (FILEOBJECT *) (pus + 1);
	pt_itmInfo->Header.ObjectType = OBJECT_FILE;
	pt_itmInfo->Header.RRV = ul_OBJ_ID;
	pt_itmInfo->FileNameLength = us;
	pt_itmInfo->HostType = us_HOST_TYPE;
	pt_itmInfo->FileAttributes = NULL;	//i.e. Read/Write & Public
	pt_itmInfo->Flags = FILEFLAG_INDOC;
	pt_itmInfo->FileSize = ul_OBJ_SIZE;
	pt_itmInfo->CompressionType = NULL;
	OSCurrentTIMEDATE( &td);
	pt_itmInfo->FileCreated = pt_itmInfo->FileModified = td;

	memcpy( (BYTE *) pt_itmInfo + sizeof( FILEOBJECT), pc_objNm, us);
	OSUnlockBlock( bid);

	us_error = NSFItemAppendObject( h_NOTE, NULL, pc_ITMNM, (WORD) strlen( 
											pc_ITMNM), bid, us_lenItem, TRUE);

	if (us_error)
		OSMemFree( bid.pool);

	return us_error;
} //us_AttachObjectItem(


/** eus_getAttachmentInfo( ***


--- parameters & return ----

RETURN: eus_SUCCESS if no error other than ERR_ITEM_NOT_FOUND occurred; the 
	Notes API error code otherwise

--- revision history -------
9/12/99 PR: added compressed-flag return
1/31/99 PR: created			*/
//DOC!!
STATUS eus_getAttachmentInfo( NOTEHANDLE  h_NOTE, 
								char  pc_ITMNM[], 
								const char  pc_ATTACHNM[], 
								DWORD *const  pul_objId, 
								DWORD *const  pul_size, 
								BOOL *const  pf_compressed, 
								BLOCKID *const  pbid_item, 
								BLOCKID *const  pbid_content)	{
	char *const  pc_itmNm = pc_ITMNM ? pc_ITMNM : ITEM_NAME_ATTACHMENT;
	BYTE * puc;
	const WORD  us_LEN_ITEMNM = strlen( pc_itmNm);

	BLOCKID  bid_itm, bid_content, bid_prevItem;
	STATUS  us_error = NULL;

	if (!( h_NOTE && pc_ATTACHNM))
		return !eus_SUCCESS;

	if (pul_objId)
		*pul_objId = NULL;
	if (pul_size)
		*pul_size = NULL;
	if (pf_compressed)
		*pf_compressed = NULL;
	if (pbid_item)
		*pbid_item = ebid_NULLBLOCKID;
	if (pbid_content)
		*pbid_content = ebid_NULLBLOCKID;

	//if no attachments exist, return success with the output variables 
	//	null, signifying this condition
	if (!NSFItemIsPresent( h_NOTE, pc_itmNm, (WORD) strlen( pc_itmNm)))
		return eus_SUCCESS;

	//get information about the first attachment item
	if (us_error = NSFItemInfo( h_NOTE, pc_itmNm, us_LEN_ITEMNM, &bid_itm, 
													NULL, &bid_content, NULL))
		return us_error;


	//if this isn't the attachment item we're looking for, see if the next 
	//	one is
	puc = OSLockBlock( BYTE, bid_content);
	while (memcmp( pc_ATTACHNM, puc + sizeof( WORD) + sizeof( FILEOBJECT), 
										strlen( pc_ATTACHNM)) != ei_SAME)	{
		OSUnlockBlock( bid_content);

		bid_prevItem = bid_itm;
		if (us_error = NSFItemInfoNext( h_NOTE, bid_prevItem, pc_itmNm, 
												us_LEN_ITEMNM, &bid_itm, 
												NULL, &bid_content, NULL))
			//if no further attachment items exist, return success with the 
			//	output variables null, signifying this condition
			if (ERR( us_error) == ERR_ITEM_NOT_FOUND)
				return eus_SUCCESS;
			//Else an unexpected error has occurred. Free whatever memory 
			//	was allocated within the function before returning the error.
			else
				return us_error;
		else
			puc = OSLockBlock( BYTE, bid_content);
	} //while (memcmp( pc_ATTACHNM, puc + sizeof( WORD) +

	if (pul_objId || pul_size)	{
		const FILEOBJECT *const  PFLO = (FILEOBJECT *) (OSLockBlock( WORD, 
														bid_content) + 1);

		if (pul_objId)
			*pul_objId = PFLO->Header.RRV;
		if (pul_size)
			*pul_size = PFLO->FileSize;
		if (pf_compressed)
			*pf_compressed = !!PFLO->CompressionType;
		OSUnlockBlock( bid_content);
	}
	if (pbid_item)
		*pbid_item = bid_itm;
	if (pbid_content)
		*pbid_content = bid_content;

	return us_error;
} //eus_getAttachmentInfo(


/** eus_AttachBufferAsObject( ***


--- parameters & return ----

RETURN: eus_SUCCESS if no error occured; the Notes API error code otherwise

--- revision history -------
1/30/99 PR: created			*/
//DOC!!
STATUS eus_AttachBufferAsObject( const BYTE *const  PUC, 
									const DWORD  ul_LEN, 
									DBHANDLE  h_DB, 
									NOTEHANDLE  h_NOTE, 
									char  pc_ITMNM[], 
									const char  pc_OBJNM[], 
									const WORD  us_HOST_TYPE)	{
	DBHANDLE  h_Db;
	DWORD  ul_objId;
	HANDLE  h;
	STATUS  us_error;

	if (!( PUC && ul_LEN && h_NOTE && pc_ITMNM && pc_OBJNM))
		return !eus_SUCCESS;

	if (!( h_Db = h_DB))
		NSFNoteGetInfo( h_NOTE, _NOTE_DB, &h_Db);
	if (us_error = NSFDbAllocObject( h_Db, ul_LEN, NOTE_CLASS_DOCUMENT, 
													(WORD) NULL, &ul_objId))
		return us_error;

	if (us_error = OSMemAlloc( (WORD) NULL, ul_LEN, &h))
		goto errJump;
	memcpy( OSLockObject( h), PUC, ul_LEN);
	OSUnlockObject( h);

	//add an "object" item to the note that references the object we're 
	//	creating
	if (us_error = us_AttachObjectItem( h_NOTE, ul_objId, pc_ITMNM, pc_OBJNM, 
														ul_LEN, us_HOST_TYPE))
		goto errJump;

	us_error = NSFDbWriteObject( h_Db, ul_objId, h, 0L, ul_LEN);

errJump:
	OSMemFree( h);
	if (us_error && ul_objId)
		NSFDbFreeObject( h_Db, ul_objId);

	return us_error;
} //eus_AttachBufferAsObject(


/** eus_getObjectContentsInBuffer( ***
Purpose is to copy the contents of a database object (usually a file) into 
a handled buffer. If the object is not compressed, it is more efficient to 
provide the object ID as opposed to the item BlockID associated with the 
note item referring to the object.

--- parameters & return ----
ul_OBJID: Provisionally Optional. The ID (RRV) of the object in the database. 
	Ignored if bid_ITEM is provided; required otherwise.
bid_ITEM: Optional. The item BlockID associated with the note item referring 
	to the object.
ul_LEN_CONTENT: Optional. The length of the content to be read into the 
	handled buffer. If omitted or equal to the API's MAXDWORD constant, the 
	entire content of the object will be read into the buffer.
h_NOTE: Provisionally Optional. If bid_ITEM is provided, the handle to the 
	note containing the item referring to the object. Else if bid_ITEM not 
	provided, the handle to any note in the database containing the object, 
	although not necessary if h_DB is provided.
h_DB: Optional. Handle to the database containing the object. Ignored if 
	bid_ITEM is provided. Otherwise if not provided, the handle will be 
	determined using by means of the h_NOTE parameter.
ph_contents: Pointer to the variable in which to store the handle to the 
	buffer filled with the object's content.
RETURN: eus_SUCCESS if no error occured. The Notes API error code if an API 
	error occurred. !eus_SUCCESS if the object contained less content than 
	that specified by ul_LEN_CONTENT.

--- revision history -------
9/12/99 PR
+ overhauled to make more generic
+ full documentation added

12/12/98 PR: created		*/
STATUS eus_getObjectContentsInBuffer( const DWORD  ul_OBJID, 
										const BLOCKID  bid_ITEM, 
										const DWORD  ul_LEN_CONTENT, 
										NOTEHANDLE  h_NOTE, 
										DBHANDLE  h_DB, 
										HANDLE *const  ph_contents)	{
	static const char  pc_FILENM_TEMP[] = "~gocib.tmp";

	static char  pc_extFileNmTemp[ mus_MAXBUF_EXTFILENM - 
													sizeof( pc_FILENM_TEMP)];

	DBHANDLE  h_Db;
	HANDLE  h = NULL;
	STATUS  us_error = NULL;
	BOOL  f_failure = FALSE;

	if (!( (ul_OBJID || bid_ITEM.pool) && (bid_ITEM.pool ? (BOOL) h_NOTE : 
													(!h_DB ? (BOOL) h_NOTE : 
													TRUE)) && ph_contents))
		return !eus_SUCCESS;

	*ph_contents = NULL;

	//if we're dealing with files here...
	if (bid_ITEM.pool)	{
		unsigned long  ul;
		int  i_err;

		//if this is the first time through with a file, initialize the 
		//	variable to hold the path to the user's temporary directory
		if (!*pc_extFileNmTemp)	{
			if (!epc_getTempDirNm( pc_extFileNmTemp, mus_MAXBUF_EXTFILENM - 
																		2))
				return !eus_SUCCESS;
			strcat( pc_extFileNmTemp, pc_FILENM_TEMP);
		}

		//extract the file as a temporary file on the file system
		if (us_error = NSFNoteExtractFile( h_NOTE, bid_ITEM, 
													pc_extFileNmTemp, NULL))
			return us_error;

		//if necessary, determine the length of the content to be read into 
		//	the buffer
		if (!ul_LEN_CONTENT || ul_LEN_CONTENT == MAXDWORD)	{
			struct stat  st;

			if (f_failure = !stat( pc_extFileNmTemp, &st))
				goto errJump;

			if (f_failure = (ul = st.st_size) <= 0)
				goto errJump;
		}else
			ul = ul_LEN_CONTENT;

		//allocate a handled buffer to accommodate the content we're going to 
		//	read
		if (us_error = OSMemAlloc( NULL, ul, &h))
			goto errJump;

		//read the specified amount of content from the file into the buffer
		f_failure = !ef_LoadBinaryFile( pc_extFileNmTemp, OSLockObject( h), 
																		ul);
		OSUnlockObject( h);
		if (f_failure)
			goto errJump;

		//delete the temporary file, ignoring failure
		i_err = remove( pc_extFileNmTemp);
		_ASSERTE( i_err == eus_SUCCESS);
	}else {
		if (!( h_Db = h_DB))
			NSFNoteGetInfo( h_NOTE, _NOTE_DB, &h_Db);
		if (us_error = NSFDbReadObject( h_Db, ul_OBJID, 0, ul_LEN_CONTENT ? 
											ul_LEN_CONTENT : MAXDWORD, &h))	{
			_ASSERTE( !h);
			return us_error;
		}
	} //if (bid_ITEM.pool)

	*ph_contents = h;

	return eus_SUCCESS;

errJump:
	if (f_failure)
		remove( pc_extFileNmTemp);

	return us_error + f_failure;
} //eus_getObjectContentsInBuffer(


