/*____________________________________________________________________________
	Copyright (C) 1998 Network Associates, Inc.
	All rights reserved.
	
	PGPsda.c - Code for decoding SDA's
	

	$Id: sdautil.c,v 1.4.12.1 1999/12/14 03:43:20 wjb Exp $
____________________________________________________________________________*/

#include "DecodeStub.h"

void GetPrefixPath(GETPUTINFO *gpi)
{
	char *p;

	GetModuleFileName(NULL,gpi->szPrefixPath, MAX_PATH);

	p=strrchr(gpi->szPrefixPath,'\\');

	if(p!=NULL)
	{
		p++;
		*p=0;
	}
	else
	{
		strcpy(gpi->szPrefixPath,"");
	}
}

BOOL  SaveOutputFile(HWND hwnd, 
					 char *Title,
					 char *InputFile, 
					 char *OutputFile)
{
	char *p;
	BOOL UserCancel = FALSE;
	OPENFILENAME SaveFileName;
	FILE *ftest;
	char StrRes[500];
	BOOL bAskUser;

	char FinalFile[MAX_PATH]="\0";
	char DefaultExtension[MAX_PATH] = "\0";
	int FileStart = 0, FileExtensionStart = 0;

	bAskUser=FALSE;

	strcpy(FinalFile, InputFile);

	if((p = strrchr(FinalFile, '\\')))
		FileStart = p - FinalFile + 1;

	if((p = strrchr(FinalFile, '.')))
	{
		FileExtensionStart = p - FinalFile + 1;
		strcpy(DefaultExtension,p); // Save old extension
								// it might get stripped
	}

	ftest=fopen(FinalFile,"rb");

	// If we could open the file, we need to ask the user
	if(ftest!=0)
	{
		fclose(ftest);
		bAskUser=TRUE;
	}
	else
	{
		// File doesn't exist, but can we create it?
		ftest=fopen(FinalFile,"wb");

		if(ftest==0)
		{
			// No, we can't
			bAskUser=TRUE;
		}
		else
		{
			// We can create the file. Close it and erase it
			fclose(ftest);
			remove(FinalFile);
		}
	}

	// Ask the user
	if(bAskUser)
	{
		LoadString (g_hinst, IDS_SAVEFILTER, StrRes, sizeof(StrRes));
		while (p = strrchr (StrRes, '@')) *p = '\0';

		SaveFileName.lStructSize=sizeof(SaveFileName); 
		SaveFileName.hwndOwner=hwnd; 
	    SaveFileName.hInstance=NULL; 
	    SaveFileName.lpstrFilter=StrRes;
		SaveFileName.lpstrCustomFilter=NULL; 
	    SaveFileName.nMaxCustFilter=0; 
		SaveFileName.nFilterIndex=1; 
  	    SaveFileName.lpstrFile=FinalFile; 
	    SaveFileName.nMaxFile=MAX_PATH; 
	    SaveFileName.lpstrFileTitle=NULL; 
		SaveFileName.nMaxFileTitle=0; 
		SaveFileName.lpstrInitialDir=NULL; 
		SaveFileName.lpstrTitle=Title; 
		SaveFileName.Flags= OFN_OVERWRITEPROMPT | 
							OFN_HIDEREADONLY | 
							OFN_NOREADONLYRETURN;
#ifdef WIN32
		SaveFileName.Flags=SaveFileName.Flags | OFN_EXPLORER;
#endif
		SaveFileName.nFileOffset=FileStart; 
		SaveFileName.nFileExtension=FileExtensionStart; 
		SaveFileName.lpstrDefExt=DefaultExtension; 
		SaveFileName.lCustData=(long)NULL; 
		SaveFileName.lpfnHook=NULL;
		SaveFileName.lpTemplateName=NULL; 

		UserCancel = !GetSaveFileName(&SaveFileName);
	}

	// We'll likely always have some kind of extension
	if(DefaultExtension[0]!=0)
	{
		p = strrchr(FinalFile, '.');

		if(p)
		{
			// Extension found
			if(!stricmp(DefaultExtension,p))
			{
				// They are the same. Woohoo! Do nothing
				;
			}
			else
			{
				// They are different. Must be that 
				// pesky hide extensions option.
				strcat(FinalFile,DefaultExtension);

				ftest=fopen(FinalFile,"rb");

				// If we could open the file, we need to ask the user
				if(ftest!=0)
				{
					fclose(ftest);
					MessageBox(hwnd,
						FinalFile,"PGP Error -- File exists",
						MB_OK|MB_ICONSTOP|MB_SETFOREGROUND);

					return TRUE;
				}
			}
		}
		else
		{
			// No extension found
			strcat(FinalFile,DefaultExtension);

			ftest=fopen(FinalFile,"rb");

			// If we could open the file, we need to ask the user
			if(ftest!=0)
			{
				fclose(ftest);
				MessageBox(hwnd,
					FinalFile,"PGP Error -- File exists",
					MB_OK|MB_ICONSTOP|MB_SETFOREGROUND);

				return TRUE;
			}
		}
	}

	strcpy(OutputFile,FinalFile);

	return(UserCancel);
}

PGPError SDAGetPassphrase(SDAWORK *SDAWork,SDAHEADER *SDAHeader,PGPUInt32 **ExpandedKey)
{
	BOOL PassphraseOK;
	char szPrompt[100];

	PassphraseOK=FALSE;
	LoadString (g_hinst, IDS_PASSPROMPT, szPrompt, sizeof(szPrompt));

	// GET PASSPHRASE
	while(!PassphraseOK)
	{
		PGPError err;
		SHAContext sha;
		byte const *HashedPassphrase;
		char PassCheckBytes[8];
		PGPUInt8		j;
		PGPUInt16		i, k;
		char *pszPassword;

		err=SDAPassphraseDialog(SDAWork->hwndWorking,szPrompt,&pszPassword);

		if(err!=kPGPError_NoErr)
			return kPGPError_UserAbort;
		
		// Hash passphrase w/ SHA
		memset(&sha,0x00,sizeof(SHAContext));

		(HashSHA.init)(&sha);
		(HashSHA.update)(&sha,
			SDAHeader->Salt.saltBytes,
			sizeof(SDAHeader->Salt.saltBytes));

		// Hash the passphrase and a rotating byte counter the specified
		// number of times into the hash field with the 8 bytes of salt
		// from above.

		k = (SDAHeader->hashReps);

		for (i=0, j=0; i<k; i++, j++)
		{
			(HashSHA.update)(&sha,pszPassword,strlen(pszPassword));	
			(HashSHA.update)(&sha,&j, 1);
		}

		HashedPassphrase=(HashSHA.final)(&sha);

		memset(pszPassword,0x00,strlen(pszPassword));
		free(pszPassword);

		*ExpandedKey=(PGPUInt32 *)malloc(sizeof(PGPUInt32)*32);
		memset(*ExpandedKey,0x00,sizeof(PGPUInt32)*32);	

		// Expand hashed passphrase 
		(cipherCAST5.initKey)(*ExpandedKey,
			HashedPassphrase);

		memcpy(PassCheckBytes,HashedPassphrase,8);

		// Check if correct by decrypting checkbytes
		(cipherCAST5.encrypt)(*ExpandedKey,
			(BYTE *)&PassCheckBytes,(BYTE *)PassCheckBytes);

		// Compare the check bytes against the key
		if (memcmp(PassCheckBytes,&(SDAHeader->CheckBytes),8)==0)
		{
			PassphraseOK=TRUE;
		}
		else
		{
			LoadString (g_hinst, IDS_WRONGPASS, szPrompt, sizeof(szPrompt));

			memset(*ExpandedKey,0x00,sizeof(PGPUInt32)*32);	
			free(*ExpandedKey);
			*ExpandedKey=NULL;
		}
	}

	return kPGPError_NoErr;
}


/*__Editor_settings____

	Local Variables:
	tab-width: 4
	End:
	vi: ts=4 sw=4
	vim: si
_____________________*/