/*____________________________________________________________________________
	Copyright (C) 1996-1999 Network Associates, Inc.
	All rights reserved.

	$Id: CGrayControls.cp,v 1.4 1999/03/10 02:34:05 heller Exp $
____________________________________________________________________________*/
#include <UEnvironment.h>
#include <UDrawingState.h>

#include "CGrayControls.h"
#include "CPFWindow.h"

CGrayEditField*
CGrayEditField::CreateGrayEditFieldStream(
	LStream	*inStream)
{
	return (new CGrayEditField(inStream));
}


CGrayEditField::CGrayEditField(
	LStream	*inStream)
		: LEditField(inStream)
{
}

void
CGrayEditField::DrawSelf()
{
	RGBColor rgbGrayShadowColor = {0xaaaa, 0xaaaa, 0xaaaa};
	Rect	frame, frame2;
	
	if(FocusDraw())
	{
		CalcLocalFrameRect(frame);
		frame2 = frame;
		if (mHasBox)
		{
			if(UEnvironment::HasFeature(env_SupportsColor))
			{
				::RGBForeColor(&rgbGrayShadowColor);
				::FrameRect(&frame);
				::ForeColor(whiteColor);
				::MoveTo(frame.left+1,frame.bottom-1);
				::LineTo(frame.right-1,frame.bottom-1);
				::LineTo(frame.right-1,frame.top+1);
				::ForeColor(blackColor);
				::InsetRect(&frame, 1, 1);
				::FrameRect(&frame);
				::InsetRect(&frame, 1, 1);
				::ForeColor(whiteColor);
				::PaintRect(&frame);
				::ForeColor(blackColor);
			}
			else
			{
				::FrameRect(&frame);
				::InsetRect(&frame, 2, 2);
			}
		}
		GrafPtr	savePort = (**mTextEditH).inPort;
		(**mTextEditH).inPort = UQDGlobals::GetCurrentPort();
	
		::TEUpdate(&frame, mTextEditH);
		
		(**mTextEditH).inPort = savePort;
	}
}

CChangingCaption*
CChangingCaption::CreateChangingCaptionStream(
	LStream	*inStream)
{
	return (new CChangingCaption(inStream));
}


CChangingCaption::CChangingCaption(
	LStream	*inStream)
		: LCaption(inStream)
{
}

void
CChangingCaption::SetDescriptor(
	ConstStringPtr	inDescriptor)
{
	Rect frame;
	
	mText = inDescriptor;
	FocusDraw();
	CalcLocalFrameRect(frame);
	ApplyForeAndBackColors();
	::EraseRect(&frame);
	DrawSelf();
}

CDarkEditField*
CDarkEditField::CreateDarkEditFieldStream(
	LStream	*inStream)
{
	return (new CDarkEditField(inStream));
}


CDarkEditField::CDarkEditField(
	LStream	*inStream)
		: LEditField(inStream)
{
}

void
CDarkEditField::DrawSelf()
{
	RGBColor rgbGrayShadowColor = {0xaaaa, 0xaaaa, 0xaaaa};
	Rect	frame, frame2;
	
	if(FocusDraw())
	{
		CalcLocalFrameRect(frame);
		frame2 = frame;
		if (mHasBox)
		{
			if(UEnvironment::HasFeature(env_SupportsColor))
			{
				::RGBForeColor(&rgbGrayShadowColor);
				::FrameRect(&frame);
				::ForeColor(whiteColor);
				::MoveTo(frame.left+1,frame.bottom-1);
				::LineTo(frame.right-1,frame.bottom-1);
				::LineTo(frame.right-1,frame.top+1);
				::ForeColor(blackColor);
				::InsetRect(&frame, 1, 1);
				::FrameRect(&frame);
				::InsetRect(&frame, 1, 1);
				::ForeColor(whiteColor);
				::PaintRect(&frame);
				::ForeColor(blackColor);
			}
			else
			{
				::FrameRect(&frame);
				::InsetRect(&frame, 2, 2);
			}
		}
		BackColor(whiteColor);
		GrafPtr	savePort = (**mTextEditH).inPort;
		(**mTextEditH).inPort = UQDGlobals::GetCurrentPort();
	
		::TEUpdate(&frame, mTextEditH);
		
		(**mTextEditH).inPort = savePort;
	}
}

Boolean
CDarkEditField::HandleKeyPress(
	const EventRecord&	inKeyEvent)
{
	Boolean		keyHandled = true;
	Int16		theKey = inKeyEvent.message & charCodeMask;
	
	FocusDraw();
	BackColor(whiteColor);
	if((inKeyEvent.modifiers & cmdKey) || ((theKey != 13) && (theKey != 3)))
		keyHandled = LEditField::HandleKeyPress(inKeyEvent);
	else
		((CPFWindow *)GetSuperCommander())->ListenToMessage(1000, NIL);
	return keyHandled;
}

