/*____________________________________________________________________________
	Copyright (C) 1996-1999 Network Associates, Inc.
	All rights reserved.

	$Id: CMacBinaryPipe.h,v 1.4 1999/03/10 02:34:38 heller Exp $
____________________________________________________________________________*/
#pragma once

#include <LThread.h>

#include "PGPFone.h"

#define noDEBUGXFERLOG

#define PGPPARTIALFILETYPE		'PGpf'
#define PGPMBPARTIALFILETYPE	'Pmpf'

#define STDPIPESIZE		(24*1024L)
#define STDPIPEEXTRA	1024L

#define SOH		0x01
#define STX		0x02
#define ETX		0x03
#define EOT		0x04
#define ENQ		0x05
#define ACK		0x06
#define BS		0x08
#define HT		0x09
#define LF		0x0A
#define CR		0x0D
#define DLE		0x10
#define XON		0x11
#define XOFF	0x13
#define NAK		0x15
#define CAN		0x18
#define SUB		0x1A
#define ESC		0x1B

#define DESKTOP		0x0001	// ---- ---- ---- ---1
#define	COLOR		0x000E	// ---- ---- ---- 111-
#define INITED		0x0100	// ---- ---1 ---- ----
#define CHANGED		0x0200	// ---- --1- ---- ----
#define BUSY		0x0400	// ---- -1-- ---- ----
#define BOZO		0x0800	// ---- 1--- ---- ----
#define SYSTEM		0x1000	// ---1 ---- ---- ----
#define BUNDLE		0x2000	// --1- ---- ---- ----
#define INVISIBLE	0x4000	// -1-- ---- ---- ----
#define LOCKED		0x8000	// 1--- ---- ---- ----

#define NOMODIFY	(DESKTOP | INITED | CHANGED | BUSY)

class CPipe;

#pragma options align=mac68k

typedef struct MacBinaryHeader
{
	uchar filler;
	uchar oldVersion;		// 000: Must be zero for compatibility
	uchar name[64];			// 001: Pascal string
	FInfo info1;			// 065: Original Finder info:
							//		File type (long)
							//		File creator (long)
							//		Flags (word, low byte must be zero)
							//		File's location (Point)
							//		File's window (short)
	uchar protectedBit;		// 081: Low order bit
	uchar zero1;			// 082: Must be zero for compatibility
	long dLength;			// 083: Data fork length (in bytes)
	long rLength;			// 087: Resource fork length (in bytes)
	ulong creation;			// 091: Creation date
	ulong modification;		// 095: Modification date
	short getInfoLength;	// 099:	Get info length
	uchar info2;			// 101: Finder flags, low byte
	uchar dummy1;
	uchar dummy2[18];		// 103: Not used
	uchar dummy3;
	uchar newVersion;		// 122: Uploading program version number
	uchar minimumVersion;	// 123: Minimum version number needed
	uchar crc1;
	uchar crc2;
} MacBinaryHeader;

#pragma options align=reset

typedef struct XferFileSpec
{
	FSSpec fs;
	long rootDir;	// if part of a directory structure, these
	short rootVol;	// specify the home directory used to determine
} XferFileSpec;		// the downward path to get to this file

typedef struct XferInfo
{
	CPipe *pipe;
	FSSpec file;
	ulong bytesTotal, bytesDone, cpsBase;
	ulong startTime, lastTime, fdType, fdCreator;
	short forceUpdate, setEOF;
	short retries, sendAs, resurrect;
	OSErr fatalErr;
} XferInfo;

typedef struct binaryTypeRec
{
	uchar ident[16];
	short len;
	long creator;
	long type;
} binaryTypeRec;

class CMacBinarySendPipe	:	public LThread
{
public:
					CMacBinarySendPipe(XferInfo *xi,
						Boolean recovery, void **outResult);
					~CMacBinarySendPipe();
	void			*Run(void);
protected:
	long			ReadFork(short fileRef, long offset, long start, long end);
	XferInfo		*mXI;
	Boolean			mRecovery;
};

class CMacBinaryReceivePipe	:	public LThread
{
public:
					CMacBinaryReceivePipe(XferInfo *xi, void **outResult);
					~CMacBinaryReceivePipe();
	void			*Run(void);
protected:
	long			WriteFork(short fileRef, long pos, long end);
	XferInfo		*mXI;
};

short SendFileAs(FSSpec *file, short remoteSystemType);
void CheckSendMethod(LThread *t, XferInfo *xFile);

