/*____________________________________________________________________________
	Copyright (C) 1996-1999 Network Associates, Inc.
	All rights reserved.

	$Id: CPFDirectoryWindow.cp,v 1.5 1999/03/10 02:35:24 heller Exp $
____________________________________________________________________________*/
#include <LBevelButton.h>
#include <LPushButton.h>
#include <PP_KeyCodes.h>

#include "CPFDirectoryWindow.h"

#include "PGPFMacUtils.h"
#include "CDirectoryNewDialog.h"
#include "CDirTable.h"
#include "CPFWindow.h"

const uchar directoryFilename[]="\pPGPFone Directory";

CPFDirectoryWindow *
CPFDirectoryWindow::CreateDirectoryWindowStream(
	LStream *inStream)
{
	return (new CPFDirectoryWindow(inStream));
}

CPFDirectoryWindow::CPFDirectoryWindow()
{
}

CPFDirectoryWindow::CPFDirectoryWindow(LStream *inStream)
	: LWindow(inStream)
{
}

CPFDirectoryWindow::~CPFDirectoryWindow()
{
	DirectoryDiskOp(TRUE);
	if(mEntries)
		pgp_free(mEntries);
}

void
CPFDirectoryWindow::FinishCreateSelf()
{
	LWindow::FinishCreateSelf();
	((LBevelButton *)FindPaneByID('bNew'))->AddListener(this);
	((LBevelButton *)FindPaneByID('bEdi'))->AddListener(this);
	((LBevelButton *)FindPaneByID('bDel'))->AddListener(this);
	(mCallButton=(LPushButton *)FindPaneByID('bCal'))->SetDefaultButton(TRUE);
	mCallButton->AddListener(this);
	mDirTable = (CDirTable *)FindPaneByID('tDir');
	mDirTable->InsertCols(1, 1, NIL, 0, TRUE);
	mDirTable->AddListener(this);
	mEntries = NIL;
	mNumEntries = 0;
	mEditing = -1;
	DirectoryDiskOp(FALSE);
	for(short inx=0;inx<mNumEntries;inx++)
		mDirTable->InsertRows(1, 32767, &mEntries[inx], sizeof(DirectoryEntry), true);
	Show();
}

void
CPFDirectoryWindow::DirectoryDiskOp(Boolean save)
{
	long	dir, len;
	short	vol, ref;
	OSErr	result;
	
	::FindFolder(kOnSystemDisk, 'pref', 1, &vol, &dir);
	result = HOpen(vol, dir, directoryFilename, fsRdWrPerm, &ref);
	if(result)
	{
		if(!save)
		{
			result=HDelete(vol, dir, directoryFilename);
			if(HCreate(vol, dir, directoryFilename, PGPFONECREATOR, 'pref'))
			{
				PGFAlert("Could not create directory file!", 0);
				return;
			}
		}
		else
			return;
	}
	else
	{
		
		if(save)
		{
			len = mNumEntries * sizeof(DirectoryEntry);
			result = FSWrite(ref, &len, mEntries);
			SetEOF(ref, len);
		}
		else
		{
			result = GetEOF(ref, &len);
			if((len % sizeof(DirectoryEntry)) == 0)
			{
				mEntries = (DirectoryEntry *)pgp_malloc(len);
				result = FSRead(ref, &len, mEntries);
				mNumEntries = len / sizeof(DirectoryEntry);
			}
		}
	}
	result = FSClose(ref);
}

void
CPFDirectoryWindow::CancelEntry()
{
	mEditing = -1;
}

void
CPFDirectoryWindow::AddEntry(
						uchar				*name,
						uchar				*address,
						enum ContactMethods	connection)
{
	DirectoryEntry dirEntry;
	STableCell cell;
	
	dirEntry.connection = connection;
	pstrcpy(dirEntry.name, name);
	pstrcpy(dirEntry.address, address);
	if(mEditing>=0)
	{
		::BlockMoveData(&dirEntry, &mEntries[mEditing], sizeof(DirectoryEntry));
		cell.row = mEditing+1;
		cell.col = 1;
		mDirTable->SetCellData(cell,&mEntries[mEditing],sizeof(DirectoryEntry));
		mEditing = -1;
	}
	else
	{
		mNumEntries ++;
		if(mEntries = (DirectoryEntry *)pgp_realloc(mEntries,
						mNumEntries * sizeof(DirectoryEntry)))
		{
			::BlockMoveData(&dirEntry, &mEntries[mNumEntries-1], sizeof(DirectoryEntry));
			mDirTable->InsertRows(1, 32767, &dirEntry, sizeof(DirectoryEntry), true);
		}
		else
			mNumEntries --;
	}
}


Boolean
CPFDirectoryWindow::HandleKeyPress(
	const EventRecord&	inKeyEvent)
{
	Boolean	keyHandled = true;
	Char16	theChar = inKeyEvent.message & charCodeMask;
	
	if((theChar == char_Return) || (theChar == char_Enter))
		Call(TRUE);
	else
		keyHandled = LWindow::HandleKeyPress(inKeyEvent);
	return keyHandled;
}

void
CPFDirectoryWindow::Call(Boolean simulateButton)
{
	CPFWindow *pfWindow;
	STableCell cell;
	
	if(simulateButton)
		mCallButton->SimulateHotSpotClick(kControlButtonPart);
	else if(mDirTable->GetNextSelectedCell(cell))
	{
		pfWindow = (CPFWindow *)GetSuperCommander();
		pfWindow->DirectoryCall(&mEntries[cell.row-1]);
		delete this;
	}
}

void
CPFDirectoryWindow::ListenToMessage(MessageT inMessage, void */*ioParam*/)
{
	CDirectoryNewDialog *dirNewDialog;
	STableCell cell;

	switch(inMessage)
	{
		case 'bNew':
			(LWindow::CreateWindow(137, this))->Show();
			break;
		case 'bEdi':
			if(mDirTable->GetNextSelectedCell(cell))
			{
				dirNewDialog = (CDirectoryNewDialog *)LWindow::CreateWindow(137, this);
				mEditing = cell.row-1;
				dirNewDialog->SetFields(mEntries[cell.row-1].connection,
										mEntries[cell.row-1].name,
										mEntries[cell.row-1].address);
				dirNewDialog->Show();
			}
			break;
		case 'bDel':
			cell.row = cell.col = 0;
			if(mDirTable->GetNextSelectedCell(cell))
			{
				mDirTable->RemoveRows(1, cell.row, true);
				::BlockMoveData(&mEntries[cell.row], &mEntries[cell.row-1],
							sizeof(DirectoryEntry) * (mNumEntries - cell.row));
				mNumEntries--;
			}
			break;
		case 'bCal':
			Call(FALSE);
			break;
		case 'clkD':
			Call(TRUE);
			break;
	}
}

