/*____________________________________________________________________________
	Copyright (C) 1996-1999 Network Associates, Inc.
	All rights reserved.

	$Id: CPFTInternet.cp,v 1.8.10.1 1999/07/09 00:02:37 heller Exp $
____________________________________________________________________________*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <AddressXlation.h>
#include <UEnvironment.h>

#include "CPFTInternet.h"

#include "CPFWindow.h"
#include "CControlThread.h"
#include "CPFPackets.h"
#include "CStatusPane.h"

short CPFTInternet::sIPDriverRef = 0;
char gResolverDone;
ResultUPP gResolverDoneUPP = NIL;
EndpointRef		CPFTInternet::sCEndpoint = NULL;

static pascal void DNRResultProc(struct returnRec *,
									char *userDataPtr)
{
	*userDataPtr = 0xFF;
}

static pascal void OTNotifyProc(EndpointCallbackInfo *context, OTEventCode code,
									OTResult result, void */*cookie*/)
{
	CPFTInternet *ci;
	short nb;
	uchar deadbuf[512];
	InetAddress deadaddr;
	
	context->cpfi->mOTResult = result;
	switch(code)
	{
		case T_DATA:
			TUnitData unitdata;
			OTFlags flags;
			OSStatus err;
			
			do
			{
				ci = context->cpfi;
				nb = ci->mNextBuffer;
				if(ci->mPktReady[nb])
				{
					unitdata.addr.maxlen = sizeof(InetAddress);
					unitdata.addr.buf = (uchar *)&deadaddr;
					unitdata.opt.maxlen = 0;
					unitdata.opt.buf = 0;
					unitdata.udata.maxlen = 512;
					unitdata.udata.buf = deadbuf;
					err = OTRcvUData(context->ep, &unitdata, &flags);
				}
				else
				{
					ci->mPktReady[nb] = FALSE;
					unitdata.addr.maxlen = sizeof(InetAddress);
					unitdata.addr.buf = (uchar *)&ci->mPktSrc[nb];
					unitdata.opt.maxlen = 0;
					unitdata.opt.buf = 0;
					unitdata.udata.maxlen = MAXPACKETBUFSIZE;
					unitdata.udata.buf = ci->mIncoming[nb];
					if(context->ep == ci->mMEndpoint)
						ci->mPktDest[nb] = _pfc_Media;
					else if(context->ep == ci->sCEndpoint)
						ci->mPktDest[nb] = _pfc_Control;
					else if(context->ep == ci->mMCEndpoint)
						ci->mPktDest[nb] = _pfc_MediaControl;
					err = OTRcvUData(context->ep, &unitdata, &flags);
					if(!err)
					{
						ci->mPktLen[nb] = unitdata.udata.len;
						ci->mPktReady[nb] = TRUE;
						++ci->mNextBuffer;
						ci->mNextBuffer %= MAXINCBUFFERS;
					}
				}
			} while(err != kOTNoDataErr);
			break;
		case T_GODATA:
			context->cpfi->mFlowOff = FALSE;
			break;
		case T_BINDCOMPLETE:
		case T_UNBINDCOMPLETE:
		case T_DNRSTRINGTOADDRCOMPLETE:
			LThread::ThreadAsynchronousResume(context->cpfi->mCThread);
			break;
	}
	return;
}

CPFTInternet::CPFTInternet(CPFWindow *cpfWindow, LThread */*thread*/, short *result)
					:	CPFTransport(cpfWindow)
{
	OSStatus err;
    InetInterfaceInfo ifaceInfo;
    struct GetAddrParamBlock pBlock;
    char remoteDotName[32];
    short inx;
    uchar *p;

	*result = noErr;
	mOTResult = 0;
	mNextBuffer = mLastBuffer = 0;
	for(inx=0;inx<MAXINCBUFFERS;inx++)
	{
		mPktReady[inx] = FALSE;
		mPktLen[inx] = 0;
	}
	mCThread = LThread::GetCurrentThread();
	mMEndpoint = mMCEndpoint = NIL;
	mInetSvc = NIL;
	mPFWindow->SetLocalAddress("\p");
	mUseOT = FALSE;
	if(!(mUseOT = UEnvironment::HasFeature(env_HasOpenTransport)))
		if(!UEnvironment::HasFeature(env_HasMacTCP))
			*result = _pge_PortNotAvail;
	if(!*result)
	{
		if(mUseOT)
		{
			if(IsntNull(sCEndpoint))
			{
				mCECI.cpfi = this;
				mCECI.ep = sCEndpoint;
				OTInstallNotifier(sCEndpoint, (OTNotifyProcPtr)&OTNotifyProc, &mCECI);
			}
			if(IsntNull(sCEndpoint) || !(err = MakeOTEndpoint(&sCEndpoint, &mCECI)))
			{
				OTInitInetAddress(&mLastAddress, CONTROLPORTNUMBER, (InetHost)0);
				OTInitInetAddress(&mRemoteAddress, CONTROLPORTNUMBER, (InetHost)0);
				if(mInetSvc = OTOpenInternetServices(kDefaultInternetServicesPath,
								NULL, &err))
				{
					OTSetAsynchronous(mInetSvc);
					mISECI.cpfi = this;
					mISECI.ep = (TEndpoint *)mInetSvc;
					OTInstallNotifier(mInetSvc, (OTNotifyProcPtr)&OTNotifyProc, &mISECI);
					// Now let's find out the local machine's IP address.
					// Remember OT must be open before doing this or
					// PPP may not have been started.
        			err = OTInetGetInterfaceInfo(&ifaceInfo, kDefaultInetInterface);
        			if(!err)
        			{
						p = (uchar *)&ifaceInfo.fAddress;
						sprintf(remoteDotName, "%ld.%ld.%ld.%ld",
								(long)p[0], (long)p[1],(long)p[2],(long)p[3]);
						c2pstr(remoteDotName);
						mPFWindow->SetLocalAddress((uchar *)remoteDotName);
        			}
				}
				else
					*result = _pge_PortNotAvail;
			}
			if(err)
				*result = err;
		}
		else
		{
			if(!sIPDriverRef)
			{
				if(err=OpenDriver("\p.ipp",&sIPDriverRef))
					*result = err;
				else if(err=OpenResolver(NIL))
					*result = err;
				gResolverDoneUPP = NewResultProc(DNRResultProc);
				// Get local IP address
				memset(&pBlock, 0, sizeof(pBlock));
				pBlock.ioResult = 1;
				pBlock.csCode = ipctlGetAddr;
				pBlock.ioCRefNum = sIPDriverRef;
				PBControlAsync((ParmBlkPtr)&pBlock);
				while(pBlock.ioResult > 0)
					mCThread->Yield();
				if(!pBlock.ioResult)
				{
					AddrToStr(pBlock.ourAddress, remoteDotName);
					c2pstr(remoteDotName);
					mPFWindow->SetLocalAddress((uchar *)remoteDotName);
				}
			}
			mLastAddress.fHost = mRemoteAddress.fHost = 0;
		}
	}
	if(*result)
		PGFAlert("Internet services could not be opened!", 0);
}

CPFTInternet::~CPFTInternet()
{
	AbortSync();
	mTMutex->Wait(semaphore_WaitForever);
	if(mState == _cs_connected)
		Disconnect();
	if(mUseOT)
	{
		if(IsntNull(sCEndpoint))
		{
			OTRemoveNotifier(sCEndpoint);
		}
		CloseOTEndpoint(&mMEndpoint);
		CloseOTEndpoint(&mMCEndpoint);
		if(mInetSvc)
			OTCloseProvider(mInetSvc);
	}
}

OSErr
CPFTInternet::MakeOTEndpoint(EndpointRef *ep, EndpointCallbackInfo *eci)
{
	TEndpointInfo info;
	OTConfiguration *config;
	OSStatus err = 0;
	
	if(ep && !*ep)
	{
		config = OTCreateConfiguration(kUDPName);
		*ep = OTOpenEndpoint(config, 0, &info, &err);
		if(!err)
		{
			TBind req, ret;
			
			eci->cpfi = this;
			eci->ep = *ep;
			OTInstallNotifier(*ep, (OTNotifyProcPtr)&OTNotifyProc, eci);
			OTSetAsynchronous(*ep);
//OT Bind
			OTInitInetAddress(&mAddress, CONTROLPORTNUMBER, (InetHost) 0);
			req.addr.len = sizeof(InetAddress);
			req.addr.buf = (uchar *) &mAddress;
			req.qlen = 1;
			ret.addr.maxlen = sizeof(InetAddress);
			ret.addr.buf = (uchar *) &mRemoteAddress;
			err = OTBind(*ep, &req, &ret);
			if(!err)
				mCThread->Block();
		}
#ifdef BETA
		// There are reasonable situations in release which can have
		// an error here, so we don't want to know about it.  But in
		// testing, every error here should be noticed.
		pgpAssert(!err);
#endif
	}
	return err;
}

OSErr
CPFTInternet::CloseOTEndpoint(EndpointRef *ep)
{
	OSErr err = 0;
	
	if(ep && *ep)
	{
		OTRemoveNotifier(*ep);
		err = OTCloseProvider(*ep);
		pgpAssert(!err);
		*ep = NIL;
	}
	return err;
}

PGErr
CPFTInternet::Connect(ContactEntry *con, short *connectResult)
{
	SndListHandle respSound = NIL;
	SndChannelPtr respSndChannel = NIL;
	uchar *p;
	long len;
	ulong respSoundDelay, nextTry;
	short channel;
	char remoteDotName[32], buf[MAXPGPFUDPSIZE];
	static hostInfo host;
	InetHostInfo ihinfo;
	Boolean found = FALSE;
	OSErr err=0;
	
	mTMutex->Wait(semaphore_WaitForever);
	SetState(_cs_connecting);
	*connectResult = _cr_Error;
	if(con->internetAddress[0])
	{
		CStatusPane::GetStatusPane()->AddStatus(0, "Contacting...");
		if(mUseOT)
		{
			/* Nothing, we're bound */
		}
		else
		{	//MacTCP Bind
			mPB.csCode = UDPCreate;
			mPB.ioCRefNum = sIPDriverRef;
			mPB.csParam.create.rcvBuff = (Ptr)mRcvBuf;
			mPB.csParam.create.rcvBuffLen = UDPRCVBUFLEN;
			mPB.csParam.create.notifyProc = NIL;
			mPB.csParam.create.localPort = CONTROLPORTNUMBER;
			mPB.csParam.create.userDataPtr = (Ptr)this;
			mPB.csParam.create.endingPort = 0;
			err = PBControlSync((ParmBlkPtr)&mPB);		pgpAssert(!err);
		}
		if(!err && !mOTResult && !mAbort)
		{
			if(mUseOT)
			{	//OT Name resolution
				OTInitInetAddress(&mRemoteAddress, CONTROLPORTNUMBER, (InetHost)0);
				if(con->internetAddress[0]<'0' || con->internetAddress[0]>'9')
				{
					err = OTInetStringToAddress(mInetSvc, con->internetAddress, &ihinfo);
					mCThread->Block();
					if(!err && !mOTResult && !mAbort)
					{
						p = (uchar *)&ihinfo.addrs[0];
						mRemoteAddress.fHost = ihinfo.addrs[0];
						sprintf(remoteDotName, "%ld.%ld.%ld.%ld",
								(long)p[0], (long)p[1],(long)p[2],(long)p[3]);
						CStatusPane::GetStatusPane()->AddStatus(0, "Host identified as %s...",
							remoteDotName);
					}
					else
						CStatusPane::GetStatusPane()->AddStatus(0, "Name lookup failed.");
				}
				else
					err = OTInetStringToHost(con->internetAddress, &mRemoteAddress.fHost);
			}
			else
			{	//MacTCP Name resolution
				gResolverDone = 0;
				err = StrToAddr(con->internetAddress, &host, gResolverDoneUPP,
								(char *)&gResolverDone);
				if(err==cacheFault)
				{
					while(!gResolverDone)
						mCThread->Yield();
				}
				if(!(err=host.rtnCode) && !mAbort)
				{
					PrepRead();
					mRemoteAddress.fHost = host.addr[0];
					if(con->internetAddress[0]<'0' || con->internetAddress[0]>'9')
					{
						AddrToStr(mRemoteAddress.fHost, remoteDotName);
						CStatusPane::GetStatusPane()->AddStatus(0, "Host identified as %s...",
							remoteDotName);
					}
				}
			}
			if(!err && !mOTResult && !mAbort)
			{
				for(short tries=MAXUDPCALLTRIES;(*connectResult == _cr_Error) && tries>0 && !mAbort;
					tries--)
				{
					buf[0] = _hpt_Setup;
					buf[1] = _ptip_Call;	len = 2;
					if(gPGFOpts.popt.idUnencrypted && gPGFOpts.popt.idOutgoing &&
						gPGFOpts.popt.identity[0])
					{
						len+= (buf[2] = strlen(gPGFOpts.popt.identity)) + 1;
						strcpy(&buf[3], gPGFOpts.popt.identity);
					}
					WriteBlock(buf, &len, _pfc_Control);
					nextTry = pgp_getticks() + 2000;
					while(!mAbort && nextTry > pgp_getticks())
					{
						if(len = Read(buf, MAXPGPFUDPSIZE, &channel))
							if(mLastAddress.fHost == mRemoteAddress.fHost)
							{
								p = (uchar *)buf;
								if(*p++ == _hpt_Setup)
									switch(*p++)
									{
										case _ptip_Accept:
											*connectResult = _cr_Connect;
											break;
										case _ptip_Busy:
											CStatusPane::GetStatusPane()->AddStatus(0, "Busy.");
											*connectResult = _cr_Busy;
											if(gPGFOpts.popt.playRing &&
												(respSound = (SndListHandle)GetNamedResource('snd ',
												"\pBusy")))
											{
												HLock((Handle)respSound);
												if(!respSndChannel)
													SndNewChannel(&respSndChannel, 0, 0, NIL);
												// play a "busy" sound
												respSoundDelay = pgp_getticks() + 1600;
												SndPlay(respSndChannel, respSound, 1);
												while(respSoundDelay > pgp_getticks())
													LThread::Yield();
											}
											break;
										case _ptip_ProbeResponse:
											if(!found)
											{
												found = TRUE;
												CStatusPane::GetStatusPane()->AddStatus(0,
														"Remote contacted, ringing.");
												if(gPGFOpts.popt.playRing &&
													(respSound = (SndListHandle)GetNamedResource('snd ',
													"\pBRing")))
												{
													HLock((Handle)respSound);
													if(!respSndChannel)
														SndNewChannel(&respSndChannel, 0, 0, NIL);
													// play a local "bring" sound
													SndPlay(respSndChannel, respSound, 1);
												}
											}
											break;
										case _ptip_Message:
											ReceiveUDPMsg(p, len -2);
											break;
									}
									break;
								}
						mCThread->Yield();
					}
				}
			}
			if(*connectResult != _cr_Connect)
			{
				if(mUseOT)
				{
					/* Nothing stay bound */
				}
				else
				{
					mPB.csCode = UDPRelease;
					mPB.ioCompletion = NIL;
					err = PBControlAsync((ParmBlkPtr)&mPB);
					pgpAssert(!err);
					while(mPB.ioResult == 1)
						mCThread->Yield();
				}
			}
		}
	}
	else
	{
		PGFAlert("No Internet address has been specified.",0);
		err = _pge_NoSrvrName;
	}
	if(*connectResult != _cr_Connect)
	{
		CStatusPane::GetStatusPane()->AddStatus(0, "Connection failed.");
		SetState(_cs_none);
	}
	else
	{
		CStatusPane::GetStatusPane()->AddStatus(0, "Connected.");
		SetState(_cs_connected);
	}
	if(respSound)
		HUnlock((Handle)respSound);
	if(respSndChannel)
		SndDisposeChannel(respSndChannel, 0);
	mTMutex->Signal();
	return err;
}

PGErr
CPFTInternet::Disconnect()
{
	OSErr result=0;
	OSStatus err;
	
	mTMutex->Wait(semaphore_WaitForever);
	if(mState == _cs_connected)
	{
		SetState(_cs_disconnecting);
		if(mUseOT)
		{
			CloseOTEndpoint(&mMEndpoint);
			CloseOTEndpoint(&mMCEndpoint);
			//CloseOTEndpoint(&mCEndpoint);
			//MakeOTEndpoint(&mCEndpoint, &mCECI);
		}
		else
		{
			mPB.csCode = UDPRelease;
			mPB.ioCompletion = NIL;
			err = PBControlAsync((ParmBlkPtr)&mPB);
			pgpAssert(!err);
			while(mPB.ioResult == 1)
				mCThread->Yield();
		}
	}
	SetState(_cs_none);
	mTMutex->Signal();
	return result;
}

PGErr
CPFTInternet::Listen(Boolean /*answer*/)
{
	short result=0, reply=_cr_NoReply, rings, slen, channel;
	ulong nextRingTime, len;
	long resplen;
	SndListHandle ringSound = NIL;
	SndChannelPtr ringSndChannel = NIL;
	OSStatus err = 0;
	uchar *p, buf[MAXPGPFUDPSIZE];
	char remoteDotName[32], remoteName[64], responsepkt[128];
	InetAddress savedAddress;
	Boolean sendResp, goodaddr, noted;

	mTMutex->Wait(semaphore_WaitForever);
	if(mUseOT)
	{
	}
	else
	{	//MacTCP Bind
		mPB.csCode = UDPCreate;
		mPB.ioCRefNum = sIPDriverRef;
		mPB.csParam.create.rcvBuff = (Ptr)mRcvBuf;
		mPB.csParam.create.rcvBuffLen = UDPRCVBUFLEN;
		mPB.csParam.create.notifyProc = NIL;
		mPB.csParam.create.localPort = CONTROLPORTNUMBER;
		mPB.csParam.create.userDataPtr = (Ptr)this;
		mPB.csParam.create.endingPort = 0;
		err = PBControlSync((ParmBlkPtr)&mPB);	pgpAssert(!err);
	}
	if(!err && !mOTResult && !mAbort)
	{
		SetState(_cs_listening);
		if(!mUseOT)
			PrepRead();
		do
		{
			if(mAnswer)
			{	// accept
				responsepkt[0] = _hpt_Setup;
				responsepkt[1] = _ptip_Accept;	resplen = 2;
				WriteBlockTo(responsepkt, &resplen, &mLastAddress);
				pgp_memcpy(&mRemoteAddress, &mLastAddress, sizeof(InetAddress));
				CStatusPane::GetStatusPane()->AddStatus(0, "Connected.");
				SetState(_cs_connected);
				break;
			}
			if((mState == _cs_calldetected) && (nextRingTime <= pgp_getticks()))
			{	// ring every 5.5 seconds
				if(rings++ >= MAXUDPRINGS)
					SetState(_cs_listening);
				else
				{
					if(!noted)
					{
						CStatusPane::GetStatusPane()->AddStatus(0,
							"Incoming call from %s(%s)...",
							remoteName, remoteDotName);
						noted = TRUE;
					}
					if(gPGFOpts.popt.playRing &&
						(ringSound = (SndListHandle)GetNamedResource('snd ', "\pRing")))
					{
						HLock((Handle)ringSound);
						if(!ringSndChannel)
							SndNewChannel(&ringSndChannel, 0, 0, NIL);
						// ring the "phone"
						SndPlay(ringSndChannel, ringSound, 1);
					}
					nextRingTime = pgp_getticks() + 5500;
				}
			}
			sendResp = FALSE;
			goodaddr = FALSE;
			pgp_memcpy(&savedAddress, &mLastAddress, sizeof(InetAddress));
			if(len = Read(buf, MAXPGPFUDPSIZE, &channel))
			{
				p=buf;
				if(*p++==_hpt_Setup)
					switch(*p++)
					{
						case _ptip_Call:
							if(mState != _cs_calldetected)
							{
								goodaddr = TRUE;
								remoteName[0]=0;
								if(len > 2)
								{
									if((slen = *p++) && (len-3 >= slen))
									{
										if(slen > 63)
											slen = 63;
										pgp_memcpy(remoteName, p, slen);
										remoteName[slen]=0;
										mPFWindow->GetControlThread()->SetRemoteName(remoteName);
									}
								}
								SetState(_cs_calldetected);
								if(mUseOT)
									OTInetHostToString(mLastAddress.fHost, remoteDotName);
								else
									AddrToStr(mLastAddress.fHost, remoteDotName);
								nextRingTime = pgp_getticks();
								rings = 0;
								sendResp = TRUE;
								noted = FALSE;
							}
							break;
						case _ptip_Probe:
							sendResp = TRUE;
							break;
						case _ptip_Message:
							ReceiveUDPMsg(p, len -2);
							break;
					}
			}
			if(sendResp)
			{
				responsepkt[0] = _hpt_Setup;
				responsepkt[1] = _ptip_ProbeResponse;	resplen = 2;
				if(gPGFOpts.popt.idUnencrypted && gPGFOpts.popt.idOutgoing &&
					gPGFOpts.popt.identity[0])
				{
					resplen+= (responsepkt[2] = strlen(gPGFOpts.popt.identity)) + 1;
					strcpy(&responsepkt[3], gPGFOpts.popt.identity);
				}
				WriteBlockTo(responsepkt, &resplen, &mLastAddress);
				sendResp = FALSE;
			}
			if(!goodaddr)
				pgp_memcpy(&mLastAddress, &savedAddress, sizeof(InetAddress));
			LThread::Yield();
		} while(!mAbort);
		if(mState != _cs_connected)
		{
			if(mUseOT)
			{
				//CloseOTEndpoint(&mCEndpoint);
				//MakeOTEndpoint(&mCEndpoint, &mCECI);
			}
			else
			{	//MacTCP Unbind
				mPB.csCode = UDPRelease;
				mPB.ioCompletion = NIL;
				err = PBControlAsync((ParmBlkPtr)&mPB);
				pgpAssert(!err);
				while(mPB.ioResult == 1)
					mCThread->Yield();
			}
		}
	}
	if(ringSound)
		HUnlock((Handle)ringSound);
	if(ringSndChannel)
		SndDisposeChannel(ringSndChannel, 1);
	if(!mAnswer && mAbort)
		result = _pge_InternalAbort;
	mAnswer = FALSE;
	mTMutex->Signal();
	return result;
}

PGErr
CPFTInternet::Reset()
{
	mAbort = FALSE;
	return noErr;
}

void
CPFTInternet::PrepRead()
{
	mRPB.csCode = UDPRead;
	mRPB.ioCompletion = NIL;
	mRPB.ioCRefNum = sIPDriverRef;
	mRPB.udpStream = mPB.udpStream;
	mRPB.csParam.receive.timeOut = 0;
	mRPB.csParam.receive.userDataPtr = NIL;
	PBControlAsync((ParmBlkPtr)&mRPB);
}

long
CPFTInternet::Read(void *data, long max, short *channel)
{
	long len = 0, rdlen;
	short startBuffer;
	char rdpkt[128];
	
	// return one packet if available
	if(mUseOT)
	{
		if(data && max)
		{
			startBuffer = mLastBuffer ++;
			mLastBuffer %= MAXINCBUFFERS;
			do
			{
				if(mPktReady[mLastBuffer])
				{
					*channel = mPktDest[mLastBuffer];
					mLastAddress.fHost = mPktSrc[mLastBuffer].fHost;
					pgpAssert(mPktLen[mLastBuffer] <= max);
					pgp_memcpy(data, mIncoming[mLastBuffer], len=mPktLen[mLastBuffer]);
					mPktReady[mLastBuffer]=FALSE;
					break;
				}
				mLastBuffer ++;
				mLastBuffer %= MAXINCBUFFERS;
			} while(mLastBuffer != startBuffer);
		}
	}
	else
	{	//MacTCP Datagram Read
		if(data && max && mRPB.ioResult!=1)
		{
			if(!mRPB.ioResult)
			{
				mLastAddress.fHost = mRPB.csParam.receive.remoteHost;
				if(mRPB.csParam.receive.rcvBuffLen<=max)
				{
					len = mRPB.csParam.receive.rcvBuffLen;
					::BlockMoveData(mRPB.csParam.receive.rcvBuff, data, len);
				}
				mRPB.csCode = UDPBfrReturn;
				PBControlSync((ParmBlkPtr)&mRPB);
			}
			PrepRead();
		}
	}
	if(len && 
		((mState == _cs_connected) && (mLastAddress.fHost != mRemoteAddress.fHost)))
	{
		uchar *p = (uchar *)data;
		
		if(*channel == _pfc_Control)
		{
			if(*p++==_hpt_Setup)
				switch(*p++)
				{
					case _ptip_Call:
						// We are already connected.  Send back a busy notice.
						rdpkt[0] = _hpt_Setup;
						rdpkt[1] = _ptip_Busy;	rdlen = 2;
						WriteBlockTo(rdpkt, &rdlen, &mLastAddress);
						break;
					case _ptip_Probe:
						// We are already connected, but we don't report that to a probe.
						// The idea is that we only reveal our status if the other
						// party is also revealing its information.
						rdpkt[0] = _hpt_Setup;
						rdpkt[1] = _ptip_ProbeResponse;	rdlen = 2;
						if(gPGFOpts.popt.idUnencrypted && gPGFOpts.popt.idOutgoing &&
							gPGFOpts.popt.identity[0])
						{
							rdlen+= (rdpkt[2] = strlen(gPGFOpts.popt.identity)) + 1;
							strcpy(&rdpkt[3], gPGFOpts.popt.identity);
						}
						WriteBlockTo(rdpkt, &rdlen, &mLastAddress);
						break;
					case _ptip_Message:
						ReceiveUDPMsg(p, len -2);
						break;
				}
		}
		len = 0;
	}
	else if((mState == _cs_connected) && (*channel == _pfc_Control) && (*(uchar *)data == _hpt_Setup))
		return 0;	// do not pass setup packets to the packet layer
	return len;
}

void
CPFTInternet::ReceiveUDPMsg(uchar */*msg*/, long /*len*/)
{
	//not implemented yet
}

PGErr
CPFTInternet::WriteBlockTo(void *buffer, long *count, InetAddress *addr)
{
	OSStatus err = kOTNoError;
	
	mTMutex->Wait(semaphore_WaitForever);
	// Send a datagram
	if(mUseOT)
	{
		TUnitData unitdata;
		
		unitdata.opt.len = 0;
		unitdata.opt.buf = (uchar *)NIL;
		unitdata.addr.len = sizeof(InetAddress);
		unitdata.addr.buf = (uchar *)addr;
		unitdata.udata.len = *count;
		unitdata.udata.buf = (uchar *)buffer;
		err = OTSndUData(sCEndpoint, &unitdata);
		if(err == kOTLookErr)
			ClearLookErr(sCEndpoint);
	}
	else
	{
		wdsEntry wdss[2];
		
		wdss[0].length=*count;
		wdss[0].ptr=(char *)buffer;
		wdss[1].length=0;
		wdss[1].ptr=NIL;
		mPB.csCode = UDPWrite;
		mPB.csParam.send.remoteHost = addr->fHost;
		mPB.csParam.send.remotePort = CONTROLPORTNUMBER;
		mPB.csParam.send.reserved = 0;
		mPB.csParam.send.checkSum = TRUE;
		mPB.csParam.send.userDataPtr = (Ptr)this;
		mPB.csParam.send.wdsPtr = (Ptr)wdss;
		err = PBControlSync((ParmBlkPtr)&mPB);
	}
	mTMutex->Signal();
	return err;
}

PGErr
CPFTInternet::WriteBlock(void *buffer, long *count, short /*channel*/)
{
	return WriteBlockTo(buffer, count, &mRemoteAddress);
}

OSStatus
CPFTInternet::ClearLookErr(EndpointRef endpoint)
{
	OSStatus err;
	
	err = OTLook(endpoint);
	if(err == T_UDERR)
	{
		TUDErr tuderr;
		InetAddress erraddr;
		uchar optbuf[255];
		
		// The most common error we get is the EADDRNOTAVAIL
		// error.  This means that a packet was sent on a
		// particular port number and there was no listener
		// on the other end so we received an ICMP reply
		// stating the port was not available.  We need to
		// read the error in order to clear it or we'll never
		// be able to send another packet on this port again.
		
		tuderr.addr.maxlen = sizeof(InetAddress);
		tuderr.addr.buf = (uchar *)&erraddr;
		tuderr.opt.maxlen = 255;
		tuderr.opt.buf = optbuf;
		err = OTRcvUDErr(endpoint, &tuderr);
		//pgpAssert(0);
	}
	return err;
}

PGErr
CPFTInternet::WriteAsync(long count, short channel, AsyncTransport *async)
{
	OSStatus err = kOTNoError;
	
	mTMutex->Wait(semaphore_WaitForever);
	// Send a datagram
	// ++++++++++++++++++++++++++++++++++++++++++++++++++++++
	// NEXT LINE OVERRIDES MULTIPLE UDP PORT USAGE
	channel = _pfc_Control;
	// ++++++++++++++++++++++++++++++++++++++++++++++++++++++
	// Since we chose not to use RTP for now, I have disabled
	// the use of other UDP ports since that is useless.
	// It works fine, but for now to satisfy users behind
	// firewalls, etc..., it seems best to stick to one port.
	
	if(mUseOT)
	{
		TUnitData unitdata;
		
	sendAgain:
		unitdata.addr.len = sizeof(InetAddress);
		unitdata.opt.len = 0;
		unitdata.opt.buf = 0;
		unitdata.udata.len = count;
		unitdata.udata.buf = (uchar *)async->buffer;
		mFlowOff = TRUE;
		switch(channel)
		{
			case _pfc_Control:
				unitdata.addr.buf = (uchar *)&mRemoteAddress;
				err = OTSndUData(sCEndpoint, &unitdata);
				if(err == kOTLookErr)
					err = ClearLookErr(sCEndpoint);
				break;
			case _pfc_Media:{
				unitdata.addr.buf = (uchar *)&mMRemoteAddress;
				err = OTSndUData(mMEndpoint, &unitdata);
				if(err == kOTLookErr)
					err = ClearLookErr(mMEndpoint);
				break;}
			case _pfc_MediaControl:
				unitdata.addr.buf = (uchar *)&mMCRemoteAddress;
				err = OTSndUData(mMCEndpoint, &unitdata);
				if(err == kOTLookErr)
					err = ClearLookErr(mMCEndpoint);
				break;
		}
		if(err == kOTFlowErr)
		{
			// The network is backed up.  This can happen on some
			// slow connections such as PPP.
			
			while(mFlowOff)
				LThread::Yield();
			goto sendAgain;
		}
#ifdef BETA
		else
		{
			pgpAssert(!err);
		}
#endif
	}
	else
	{
		wdsEntry wdss[2];
		
		wdss[0].length=count;
		wdss[0].ptr=(char *)async->buffer;
		wdss[1].length=0;
		wdss[1].ptr=NIL;
		mPB.csCode = UDPWrite;
		mPB.csParam.send.remoteHost = mRemoteAddress.fHost;
		switch(channel)
		{
			case _pfc_Control:
				mPB.csParam.send.remotePort = CONTROLPORTNUMBER;
				break;
			case _pfc_Media:
				mPB.csParam.send.remotePort = RTPPORTNUMBER;
				break;
			case _pfc_MediaControl:
				mPB.csParam.send.remotePort = RTCPPORTNUMBER;
				break;
		}
		mPB.csParam.send.reserved = 0;
		mPB.csParam.send.checkSum = TRUE;
		mPB.csParam.send.userDataPtr = (Ptr)this;
		mPB.csParam.send.wdsPtr = (Ptr)wdss;
		err = PBControlSync((ParmBlkPtr)&mPB);
		//pgpAssert(!err);
	}
	mTMutex->Signal();
	return err;
}

PGErr
CPFTInternet::BindMediaStreams()
{
	OSStatus err=0;
	
	if(mUseOT)
	{
		/*OTInitInetAddress(&mMRemoteAddress, RTPPORTNUMBER, (InetHost)0);
		mMRemoteAddress.fHost = mRemoteAddress.fHost;
		OTInitInetAddress(&mMCRemoteAddress, RTCPPORTNUMBER, (InetHost)0);
		mMCRemoteAddress.fHost = mRemoteAddress.fHost;
		err = MakeOTEndpoint(&mMEndpoint, &mMECI);
		OTInitInetAddress(&localAddr, RTPPORTNUMBER, (InetHost) 0);
		req.addr.len = sizeof(InetAddress);
		req.addr.buf = (uchar *) &localAddr;
		req.qlen = 1;
		ret.addr.maxlen = sizeof(InetAddress);
		ret.addr.buf = (uchar *) &remAddr;
		err = OTBind(mMEndpoint, &req, &ret);
		if(!err)
			mCThread->Block();
#ifdef BETA
		pgpAssert(!err);
#endif
		if(!err && !mOTResult)
		{
			err = MakeOTEndpoint(&mMCEndpoint, &mMCECI);
			OTInitInetAddress(&localAddr, RTCPPORTNUMBER, (InetHost) 0);
			req.addr.len = sizeof(InetAddress);
			req.addr.buf = (uchar *) &localAddr;
			req.qlen = 1;
			ret.addr.maxlen = sizeof(InetAddress);
			ret.addr.buf = (uchar *) &remAddr;
			err = OTBind(mMCEndpoint, &req, &ret);
			if(!err)
				mCThread->Block();
#ifdef BETA
			pgpAssert(!err);
#endif
		}
		if(err)
			return err;
		else
			return mOTResult;*/
	}
	else
	{
		// #####todo
		return err;
	}
	return 0;
}

void
CPFTInternet::CleanUp()
{
	if(sIPDriverRef)
	{
		CloseResolver();
		DisposeRoutineDescriptor(gResolverDoneUPP);
		gResolverDoneUPP = NIL;
	}
	CloseOTEndpoint( &sCEndpoint );
}

