#!/usr/bin/tcl
#
set home $env(HOME)
set libdirdef(root) "/usr/local/lib/addressbook"
set libdirdef(user) "$home/addressbook"
set instdef(root) "/usr/local/bin"
set instdef(user) "$home/bin"
set countrydef(english) "USA"
set countrydef(german) "D"
set countrydef(french) "F"
set areadef(english) "1212"
set areadef(french) "1"
set areadef(german) "089"

proc askfor {text def} {
    puts -nonewline "$text \[$def\] "
    set answer [gets stdin]
    if {$answer == ""} {
	set answer $def
    }
    return $answer
}

proc lookfor {program} {
    if [catch { set path [exec which $program] }] {
	set path {}
    }
    return $path
}

puts "**************************************"
puts "*                                    *"
puts "*          Addressbook 0.5           *"
puts "*                                    *"
puts "*  Copyright (C) 1995 Clemens Durka  *"
puts "*                                    *"
puts "*        Installationprocedure       *"
puts "*                                    *"
puts "**************************************"
puts " "
puts " "
puts "You have two possibilities to install addressbook: as root or as user"
puts "root: will install it in a public directory like /usr/local/bin, so"
puts "      that all user of the system can use it. However everyone can"
puts "      have a personal configfile to override defaults. (recommended)"
puts "      You have to be root now, to install as root. If not, please"
puts "      press Ctrl+C now and restart the installation as root."
puts "user: will install it in your private homedirectory. Only recommended,"
puts "      if you have no root privileges and your sysadmin has no time to"
puts "      install it."
puts " "

# if [file exists tmp/addressbook] {
#    puts "You have configured it previously."
#    if {[askfor "Do you want to use there files (yes/no)" "yes"] != "yes"} {
#	set corret "yes"
#    }
# }

set correct "no"
while {$correct != "yes"} {
    set installas  [askfor "Install as (root/user)" root]
    puts " "
    set language [askfor "Default language (english/german/french)" "english"]
    set mycountry [askfor "Country you are in (use countrycode like USA,CDN,D,F,GB)" $countrydef($language)]
    puts "Telephone area code (for correct omission for local calls including 1 for USA"
    set myareacode [askfor "(like 1212 for New York, 1 for Paris, 089 for Mnchen)" $areadef($language)]
    puts " "
    puts "For the following questions, the default answers should work."
    puts " "
    set installin  [askfor "Where should the programm be installed" $instdef($installas)]
    set libdir     [askfor "Librarydirectory" $libdirdef($installas)]
    set configfile [askfor "Global Configurationfile" "$libdir/addressbook.config"]
    set myconfigfile [askfor "Private Configurationfile" "~/.addressbook.config"]
    set adrfile    [askfor "Default Addressfile" "$libdir/addresses.dat"]
    set wish       [askfor "Where is the wish programm" [lookfor wish]]
    puts " "
    puts "The following programs are not absolutely needed"
    set a2ps       [askfor "Where is the a2ps programm" [lookfor a2ps]]
    set latex      [askfor "Where is the latex programm" [lookfor latex]]
    set dvips      [askfor "Where is the dvips programm" [lookfor dvips]]
    set perl       [askfor "Where is the perl programm" [lookfor perl]]
    puts " "
    puts " "
    puts "************************************************************"
    puts "Your answers:"
    puts " "
    puts "Install as:         $installas"
    puts "Language:           $language"
    puts "Country:            $mycountry"
    puts "Areacode:           $myareacode"
    puts "Install in:         $installin"
    puts "Librarydirectory:   $libdir"
    puts "Global Configfile:  $configfile"
    puts "Private Configfile: $myconfigfile"
    puts "Addressfile:        $adrfile"
    puts "wish program:       $wish"
    puts "a2ps program:       $a2ps"
    puts "latex program:      $latex"
    puts "dvips program:      $dvips"
    puts "perl program:       $perl"
    puts " "
    puts "************************************************************"
    puts " "

    set correct [askfor "Is everything correct now (yes/no)" "yes"]
}

catch {mkdir "tmp"}

if [catch {set f [open "tmp/addressbook" w]} result] {
    puts "Error on writing [exec pwd]/tmp/addressbook: $result"
    exit
} else {
    puts $f "#!$wish -f"
    puts $f "#  ^^^^^^^^^^^^^^^^^^^^^^^ modify the path to find wish on your computer#"
    puts $f "set configfile \"$configfile\""
    puts $f "set myconfigfile \"$myconfigfile\""

    if [catch {set g [open "bin/addressbook" r]} result] {
	puts "Error on reading [exec pwd]/bin/addressbook: $result"
	exit
    } else {
        # Ignore the first 6 lines
	set line [gets $g]
	set line [gets $g]
	set line [gets $g]
	set line [gets $g]
	set line [gets $g]
	set line [gets $g]
        
	while {![eof $g]} {
	    puts $f [gets $g]
	}
	close $g
    }
    close $f
    catch {exec chmod 0755 tmp/addressbook}
}


if [catch {set f [open "tmp/tel" w]} result] {
    puts "Error on writing [exec pwd]/tmp/tel: $result"
    exit
} else {
    puts $f "#!$perl"
    puts $f "#  ^^^^^^^^^^^^^^^^^^^^^^^ modify the path to find perl on your computer#"
    puts $f "\$HOME=\$ENV{HOME};" 
    puts $f "\$CONFIGFILE=\"$configfile\";"
    puts $f "\$MYCONFIGFILE=\"\$HOME/.addressbook.config\";"

    if [catch {set g [open "bin/tel" r]} result] {
	puts "Error on reading [exec pwd]/bin/tel: $result"
	exit
    } else {
        # Ignore the first 7 lines
	set line [gets $g]
	set line [gets $g]
	set line [gets $g]
	set line [gets $g]
	set line [gets $g]
	set line [gets $g]
	set line [gets $g]
        
	while {![eof $g]} {
	    puts $f [gets $g]
	}
	close $g
    }
    close $f
    catch {exec chmod 0755 tmp/tel}
}


if [catch {set f [open "tmp/addressbook.config" w]} result] {
    puts "Error on writing [exec pwd]/tmp/addressbook.config: $result"
    exit
} else {
    if [catch {set g [open "lib/addressbook.config" r]} result] {
	puts "Error on reading [exec pwd]/lib/addressbook.config: $result"
	exit
    } else {
	while {![eof $g]} {
	    set line [gets $g]
	    switch -glob $line {
		"language*" {
		    set line "language $language"
		}
		"mycountry*" {
		    set line "mycountry $mycountry"
		}
		"myareacode*" {
		    set line "myareacode $myareacode"
		}
		"libdir*" {
		    set line "libdir $libdir"
		}
		"adrfile*" {
		    set line "adrfile $adrfile"
		}
		"latex*" {
		    set line "latex $latex"
		}
		"a2ps*" {
		    set line "a2ps $a2ps"
		}
		"dvips*" {
		    set line "dvips $dvips"
		}
	    }
	    puts $f $line
	}
	close $g
    }
    close $f
}

puts "Addressbook is now configured. If you want, you can verify."
puts "the files in the ./tmp directory"
puts " "

if {[askfor "Do you want to install it now (yes/no)" "yes"] != "yes"} {
    puts "Installation not completed."
    exit
}

if [catch {exec mkdir $installin} result] {
    puts "Following error occured while installing: $result"
    puts "*** If the directory already exists, you can ignore the error. if not, do 'mkdir $installin'"
}

if [catch {exec cp tmp/addressbook $installin/addressbook} result] {
    puts "Following error occured while installing: $result"
    puts "*** Please invoce the command 'cp tmp/addressbook $installin'"
}

if [catch {exec mkdir $libdir} result] {
    puts "Following error occured while installing: $result"
    puts "*** Ignore or 'mkdir $libdir'"
}

if [catch {exec cp tmp/addressbook.config $configfile} result] {
    puts "Following error occured while installing: $result"
    puts "*** Please invoce the command 'cp tmp/addressbook.config $configfile'"
}

if [catch {exec mkdir $libdir/bitmaps} result] {
    puts "Following error occured while installing: $result"
    puts "*** Ignore or 'mkdir $libdir/bitmaps'"
}

if [catch {exec mkdir $libdir/sample} result] {
    puts "Following error occured while installing: $result"
    puts "*** Ignore or 'mkdir $libdir/sample'"
}

if [catch {
    foreach p {author email fax l le ll mail phone phonepriv phonework r re rr} {
	exec cp lib/bitmaps/$p $libdir/bitmaps
    }
}] {
    puts "Following error occured while installing: $result"
    puts "*** Please invoce the command 'cp lib/bitmaps/* $libdir/bitmaps'"
}

if [catch {
    foreach p {addresses.dat addresses.dat.fmt countries english.helptext english.translation german.helptext german.translation french.helptext french.translation} {
	exec cp lib/$p $libdir
    }
}] {
    puts "Following error occured while installing: $result"
    puts "*** Please invoce the command 'cp lib/\[ac-z\]* $libdir'"
}

if [catch {
    foreach p {README addresses_onlyphone.dat.fmt addresses_private.dat.fmt addresses_work.dat.fmt} {
	exec cp sample/$p $libdir/sample
    }
}] {
    puts "Following error occured while installing: $result"
    puts "*** Please invoce the command 'cp tmp/* $libdir/sample'"
}

if [catch {exec cp tmp/tel $installin/tel} result] {
    puts "Following error occured while installing: $result"
    puts "*** Please invoce the command 'cp bin/tel $installin'"
}

if [catch {exec ln -s tel $installin/fax} result] {
    puts "Following error occured while installing: $result"
    puts "*** Please invoce the command 'ln -s tel $installin/fax'"
}

if [catch {exec ln -s tel $installin/email} result] {
    puts "Following error occured while installing: $result"
    puts "*** Please invoce the command 'ln -s tel $installin/email'"
}

exit
