### Copyright (C) 1995 Jesper K. Pedersen
### This program is free software; you can redistribute it and/or modify
### it under the terms of the GNU General Public License as published by
### the Free Software Foundation; either version 2 of the License, or
### (at your option) any later version.
###
### This program is distributed in the hope that it will be useful,
### but WITHOUT ANY WARRANTY; without even the implied warranty of
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
### GNU General Public License for more details.
###
### You should have received a copy of the GNU General Public License
### along with this program; if not, write to the Free Software
### Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

set hash "\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#"
############################################################
# First of all check for the right version of wish
############################################################
if {$tk_version != "4.0"} {
  puts {!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                            WARNING

    The Dotfile Generator requires at least Tcl 7.4 / Tk4.0}
  puts "    Your version is $tk_version"
  puts {
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
}
wm title . "Dotfile Generator"
wm withdraw .

############################################################
#                   sourcing the module
############################################################
proc import {file} {
  global argv files
  source [lindex $argv 1]/$file
  lappend files $file
}
source [lindex $argv 1]/main.template

############################################################
#                     Sourceing funktion files
############################################################
foreach file {parse types menus help functions util save
  setup inout fillouts edit versionUpdate dialog} {
  source [lindex $argv 0]/$file.tcl
}

############################################################
#           and now for the copyright notice
############################################################
if {[lindex $argv 2] != "bytecompile"} {
  puts "The Dotfile Generator version 1.1 Copyright (C) 1995 Jesper K. Pedersen"
  puts "The Dotfile Generator comes with ABSOLUTELY NO WARRANTY; for details"
  puts "see the \"about\" menu. This is free software, and you are welcome to"
  puts "redistribute it under certain conditions; see the \"about\" menu"
  puts "for details."
}

############################################################
#                    General initializion
############################################################
if {![info exists setup(dotfile)]} {
    set setup(dotfile) {{file1 Dotfile output.dot}}
}
foreach elm $setup(dotfile) {
    set fileHandles([lindex $elm 0]) [lindex $elm 2]
}
if {![info exists setup(file)]} {
  set setup(file) 1
}
if {![info exists setup(print)]} {
  set setup(print) 1
}
if {![info exists setup(whatToGenerate)]} {
  set setup(whatToGenerate) selected
}
if {![info exists setup(generateDefault)]} {
  set setup(generateDefault) 0
}
if {![info exists setup(placeWindows)]} {
  set setup(placeWindows) 1
}
if {![info exists setup(preventBytecompile)]} {
  set setup(preventBytecompile) 0
}
upvar \#0 setup(generateDefault) generateDefault
if {![info exists setup(saveOnGenerate)]} {
  set setup(saveOnGenerate) 0
}
if {![info exists module(overAllDesc)]} {
  set module(overAllDesc) "\$commentChar This file has been auto generated\n\$commentChar by the $module(name) module for the Dotfile Generator\n\$commentChar on \[exec date\]\n"
}
if {$argv == ""} {
  puts "To start this program, type wish <template file> <dotfile path> <module path>"
  exit -1
}

set changed 0
set fillOutCounter 0    ;# just to avoid testing existens
set editInfo(trace) 0
set editInfo(menuload) 0
set clipboardName ""    ;# just to avoid testing existens
set editInfo(version) "1.1"
set editInfo(releaseDate) "Sep 13, 1995"
set editInfo(name) ""   ;# just to avoid testing existens

############################################################
#             loading all the files.
############################################################
parseFile
if {[file exists [lindex $argv 1]/bytecompile]} {
  set byteTime [file mtime [lindex $argv 1]/bytecompile]
  set loadByteCompile 1
  foreach file [glob [lindex $argv 1]/*] {
    if {[file mtime $file] > $byteTime} {
      set loadByteCompile 0
      break
    }
  }
} else {
  set loadByteCompile 0
}

if {$loadByteCompile} {
  if {[lindex $argv 2] == "bytecompile"} exit
  source [lindex $argv 1]/bytecompile
} else {
  set w [makeTempWindow Loading]
  pack [label $w.text -text {Loading Information...Please wait}]
  for {set i 0} {$i < [llength $progList]} {incr i} {
    pack [label $w.$i -relief groove -bd 1] -side left -fill x -expand 1
  }
  set i 0
  foreach menu $progList {
    set editInfo(name) $menu
    set changeFunc($menu) {}
    set ok($menu) {}
    set desc($menu) {}
    set pageEnd($menu) {}
    set checkList {}
    $menu
    unset checkList
    $w.$i configure -background black
    update
    incr i
  }
  catch "destroy $w"

  if {[lindex $argv 2] != "bytecompile" && !$setup(preventBytecompile)} {
    if {([file writable [lindex $argv 1]/bytecompile] && [file exists [lindex $argv 1]/bytecompile]) || ([file writable [lindex $argv 1]] && ![file exists [lindex $argv 1]/bytecompile]) } {
      set bytecompile [tk_dialog .bytecompile "Bytecompile ?" "To improve performance you can byte-compile the dotdotfiles, do you want that?" questhead 1 No Yes]
    } else {
      puts "\n\nTo improve performence, please tell the owner"
      puts "of \"[lindex $argv 1]/\" to bytecompile the module,"
      puts "which he does by typeing \"dotfile <module name> bytecompile\""
      set bytecompile 0
    }
  } else {
    if {$setup(preventBytecompile)} {
      set bytecompile 0
    } else {
      set bytecompile 1
    }
  }
  if {$bytecompile} {
    ### writeing the bytecompile file
    set w [makeTempWindow "Byte compiling"]
    pack [label $w.text -text "Byte compiling the $module(name) module\nPlease wait"]
    for {set i 0} {$i < 11} {incr i} {
      pack [label $w.$i -relief groove -bd 1] -side left -fill x -expand 1
    }
    update
    
    set OUT [open [lindex $argv 1]/bytecompile w]
    set i 1

    ### saveing the module global variable
    if {[info exists saveVars]} {
      puts $OUT "$hash\n\# module global variables\n$hash"
      foreach elm $saveVars {
	upvar \#0 $elm variable
	if {[array exists variable]} {
	  foreach arrayElm [array names variable] {
	    puts $OUT "set ${elm}($arrayElm) \"[escape $variable($arrayElm)]\""
	  }
	} elseif {[info exists variable]} {
	  puts $OUT "set $elm \"[escape $variable]\""
	}
      }
    }
    $w.0 configure -background black
    update

    ### writeing all my arrays
    foreach arr {changeFunc ok desc shortDesc pageEnd initFunc children \
		     widgetArgs parent TKargs} {
      puts $OUT "$hash\n\# $arr\n$hash"
      foreach elm [array names $arr] {
	puts $OUT "set ${arr}($elm) \"[escape [set ${arr}($elm)]]\""
      }
      $w.$i configure -background black
      update
      incr i
    }
    catch "destroy $w"


    close $OUT
    if {[lindex $argv 2] == "bytecompile"} exit
  }
}

############################################################
#                loading the save file
############################################################
wm withdraw .
initialize_and_load

############################################################
# linking all variable globaly as func@var
############################################################
foreach function $progList {
  set editInfo(name) $function
  linkVars $function top $function
}
set editInfo(name) ""   ;# just to avoid testing existens

############################################################
#                      Menu WINDOW
############################################################

frame .menu
pack .menu -expand 1 -fill both
subType "/"

frame .buttons
pack .buttons -side bottom -expand 1 -fill both
pack [frame .buttons.f1] [frame .buttons.f2] \
    -expand 1 -fill x
button .buttons.f1.quit -text "QUIT" -command quit -width 9
button .buttons.f1.about -text "About" -command about -width 9
button .buttons.f1.setup -text "Setup" -command setup -width 9
button .buttons.f2.save -text "Save" -command saveFile -width 9
button .buttons.f2.reset -text "Reset Page" -command resetToDefult -width 9
button .buttons.f2.generate -text "Generate" -command generate -width 9
bind .buttons.f1.setup <3> "generalHelp Setup"
bind .buttons.f2.save <3> "generalHelp \"Internal Status\""
bind .buttons.f2.reset <3> "generalHelp \"Reset Page\""
bind .buttons.f2.generate <3> "generalHelp Generate"

pack .buttons.f1.about .buttons.f1.setup .buttons.f1.quit  -side left -expand 1 -fill both
pack  .buttons.f2.save .buttons.f2.reset .buttons.f2.generate -expand 1 -fill both -side left

############################################################
#               global bindings for entry's
############################################################
bind Entry <Double-ButtonPress-3> {%W delete sel.first sel.last}
bind . <Control-s> generate
if {$setup(placeWindows)} {
  wm geometry . +0+0
}
wm deiconify .

