### Copyright (C) 1995 Jesper K. Pedersen
### This program is free software; you can redistribute it and/or modify
### it under the terms of the GNU General Public License as published by
### the Free Software Foundation; either version 2 of the License, or
### (at your option) any later version.
###
### This program is distributed in the hope that it will be useful,
### but WITHOUT ANY WARRANTY; without even the implied warranty of
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
### GNU General Public License for more details.
###
### You should have received a copy of the GNU General Public License
### along with this program; if not, write to the Free Software
### Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


############################################################
#          general help page, called from the menu.
############################################################
proc generalHelp {{text ""}} {
  global generalHelpIndex textIndexes argv
  set defaultFont "-*-helvetica-medium-r-*-*-12-*"
  set italicFont "-*-helvetica-medium-o-*-*-12-*"
  set boldFont  "-*-helvetica-bold-r-*-*-12-*"
  set largeFont "-*-helvetica-medium-r-*-*-18-*"

  if {[winfo exists .help]} {
    wm deiconify .help
    raise .help
  } else {
    toplevel .help
    button .help.quit -text "Quit Help" -command {
      catch "destroy .help"
    }
    pack .help.quit -side bottom  -padx 5 -pady 5
    for {set i 0} {$i < 2} {incr i} {
      frame .help.f$i
      pack .help.f$i -side left -anchor n -expand 1 -fill both
    }
    
    # making the widgets
    text .help.text -wrap word -font $defaultFont \
	-yscrollcommand ".help.textscroll set" -width 50
    scrollbar .help.textscroll -command ".help.text yview"
    pack .help.text .help.textscroll -in .help.f1 -side left -fill y 
    
    listbox .help.lbox 	-relief raised -borderwidth 2 -width 30 
    pack .help.lbox  -in .help.f0 -fill y -expand 1
    bind .help.lbox <ButtonRelease-1> {
      .help.text yview $generalHelpIndex([.help.lbox curselection])
      .help.lbox selection clear 0 end
    }
    catch {unset textIndexes}
    set header 0
    source [lindex $argv 0]/generatedHelp
    if {[file exists [lindex $argv 1]/generatedHelp]} {
      .help.lbox insert end "--------"
      set generalHelpIndex($header) $index
      incr header
      source [lindex $argv 1]/generatedHelp
    }
    .help.text tag configure header -font $largeFont
    .help.text tag configure italic -font $italicFont
    .help.text tag configure bold -font $boldFont
    .help.text configure -state disabled

  }

  if {$text == ""} {
    .help.text yview 1.0
    return
  }
  
  if {[lsearch -exact $textIndexes $text] != -1} {
    .help.text yview $generalHelpIndex([lsearch -exact $textIndexes $text])
  } elseif {[lsearch -glob $textIndexes $text*] != -1} {
    .help.text yview $generalHelpIndex([lsearch -glob $textIndexes $text*])
  }
}

############################################################
#                   show the about box
############################################################
proc about {} {
  global module editInfo
  set index [tk_dialog .about "About the Dotfile Generator" \
		 "This is the Dotfile Generator\nmade by:\nJesper Pedersen\nOdense University\nDenmark\n\nVersion: $editInfo(version)\nRelease date: $editInfo(releaseDate)\n\nModule name: $module(name)\nCreator: $module(creator)\nVersion: $module(version)" {} 0 OK "Show the help pages" "show warranty" "show copying"]
  if {$index == 1} {generalHelp}
  if {$index == 2} {showFile Warranty}
  if {$index == 3} {showFile Copying}
}

############################################################
#  This takes care of help for the element on the menu
############################################################
proc help {name} {
  global editInfo widgetArgs
  set function $editInfo(name)
  set help $widgetArgs(${function}__${name}__help)
  set text $widgetArgs(${function}__${name}__text)
  setDesc "[subst $text]\n\n$help"
}

############################################################
#         This function takes care of help for
#         element's in listbox's
############################################################
proc listbox_help {path name y} {

  global widgetArgs editInfo parent
  set function $editInfo(name)
  set index [$path.box nearest $y]
  set entries $widgetArgs(${function}__${name}__entries)
  set entryhelp $widgetArgs(${function}__${name}__entryhelp)
  set help [join [lindex $entryhelp [expr 2*$index+1]]]
  if {$help == ""} {
    set help $widgetArgs(${function}__${name}__help)
    set text $widgetArgs(${function}__${name}__text)
  } else {
    set text [lindex $entries $index ]
  }
  setDesc "$text\n\n$help"
}

############################################################
#         This function takes care of help for
#         element's in menu's
############################################################
proc menu_help {name index} {
  global widgetArgs editInfo parent
  set function $editInfo(name)
  set entries $widgetArgs(${function}__${name}__entries)
  set entryhelp $widgetArgs(${function}__${name}__entryhelp)
  set help [join [lindex $entryhelp [expr 2*$index+1]]]
  if {$help == ""} {
    set help $widgetArgs(${function}__${name}__help)
    set text $widgetArgs(${function}__${name}__text)
  } else {
    set text [lindex $entries $index ]
  }
  setDesc "$text\n\n$help"
}

proc showFile {file} {
  global argv
  set w [makeTempWindow ""]
  button $w.ok -text "OK" -command {catch "destroy $w"}
  pack $w.ok -side bottom

  text $w.mesg -yscrollcommand "$w.scroll set"
  scrollbar $w.scroll -command "$w.mesg yview"
  pack $w.mesg $w.scroll -side left -fill y
  set FILE [open [lindex $argv 0]/$file]
  while {![eof $FILE]} {
    gets $FILE line
    $w.mesg insert end "$line\n"
  }
  $w.mesg configure -state disabled
}
