### Copyright (C) 1995 Jesper K. Pedersen
### This program is free software; you can redistribute it and/or modify
### it under the terms of the GNU General Public License as published by
### the Free Software Foundation; either version 2 of the License, or
### (at your option) any later version.
###
### This program is distributed in the hope that it will be useful,
### but WITHOUT ANY WARRANTY; without even the implied warranty of
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
### GNU General Public License for more details.
###
### You should have received a copy of the GNU General Public License
### along with this program; if not, write to the Free Software
### Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


############################################################
# This is the funktion which takes care of the menu's
############################################################
proc subType {type} {
  global subPath widget2Help pathProgsNames menu2funk editInfo

  ### checking if a page is being loaded
  if {$editInfo(menuload)} return
  set editInfo(menuload) 1

  ### check the page before we leave it.
  if {[checkPage] == 0} {
    set editInfo(menuload) 0
    return
  }
  ### getting the size of the configuration window and destroying it.
  if {[winfo exists .edit]} {
    if {![regexp {^[0-9]+x[0-9]+([+-][0-9]+[+-][0-9]+)$} [wm geometry .edit] all editInfo(windowLocation)]} {
      catch "unset editInfo(windowLocation)"
    }
    destroy .edit
  }
  
  catch "destroy .menu"
  frame .menu

  pack .menu -expand 1 -fill both
  foreach but $subPath($type) {
    if {[info exists menu2funk($type$but)]} {
      button .menu._$but -text $but \
	  -command "loadMenu $menu2funk($type$but)" -anchor w
    } else {
      button .menu._$but -text "$but-->" \
	  -command "subType {$type$but/}" -anchor w
    }
    pack .menu._$but -fill both -expand 1
    bind .menu._$but <3> "generalHelp Menus"
  }
  
  if {$type != "/"} {
    regexp {^(.*)/([^/]*)/$} $type all dirname basename
    button .menu.back -text "<---Back" \
	-command "subType \"$dirname/\"" -anchor w
    pack .menu.back -fill both -expand 1
    bind .menu.back <3> "generalHelp Menus"
  }
  set editInfo(menuload) 0
}   

############################################################
# This funktion is called when a menu page is about to be
# created. It is here all initialization is done.
############################################################
proc loadMenu {function} {
  global editInfo children saveInfo loaded pathProgsNames \
      setup ok checkList activeNivau changeFunc desc initFunc pageEnd changeElm

  # check that we are not loading a menu
  # which could happend if the user choose a new menu to fast.
  if {$editInfo(menuload)} return
  set editInfo(menuload) 1

  ### check the page before we leave it.
  if {[checkPage] == 0} {
    set editInfo(menuload) 0
    return
  }

  if {$editInfo(name) == $function && [winfo exist .edit]} {
    set editInfo(menuload) 0
    return
  }
  
  # check if the window exist, if not create it.
  if {![winfo exists .edit]} {
    makeEdit
  } else {
    catch "destroy .edit.options"
  }

  # unlink all variables
  if {$editInfo(name) != ""} {
    unlink top ""
    catch {unset activeNivau}
  }
  
  frame .edit.options -borderwidth 1 -relief sunken
  pack .edit.options -after .edit.name -expand 1 -fill both -expand 1 
  
  set editInfo(name) $function

  # create the change function
  setChangeFunc
  
  .edit.name.2 configure -text $pathProgsNames($function)

  setWhatToGenerate
  # packing the page
  packAll .edit.options $function 0
  
  # setting the description
  setDesc $desc($function)

  # linking the variables of top
  linkVars $function top

  wm deiconify .edit
  raise .edit
  set editInfo(menuload) 0
}

proc changeAll {name} {
  global changeElm editInfo changeFunc widgetArgs children
  set function $editInfo(name)
  set type $widgetArgs(${function}__${name}__type)

  if {$type == "extentry"} {
    forevery $name "foreach child {$children(${function}__$name)} {changeAll \$child}"
  } elseif {$type == "frame" || $type == "filloutelm"} {
    foreach child $children(${function}__$name) {
      changeAll $child
    }
  } else {
    set changeElm $name
    uplevel \#0 $changeFunc($function)
  }
}

proc checkPage {} {
  global editInfo pageEnd

  set function $editInfo(name)
  if {$function == ""} return

  # evaluate the checkfunction
  set err [catch {uplevel \#0 $pageEnd($function)} errmsg]

  if {$err} {
    # check if the window exist, if not create it.
    if {![winfo exists .edit]} {
      makeEdit
      frame .edit.options -borderwidth 1 -relief sunken
      pack .edit.options -after .edit.name -expand 1 -fill both -expand 1 
      packAll .edit.options $function 0
    }
    tk_dialog .errmsg "Error in page" $errmsg error 0 OK
    return 0
  }
  return 1
}
