# jbr_util.tcl - utility procedures for jbrowser
#
######################################################################
# Copyright 1992-1995 by Jay Sekora.  This file may be freely        #
# distributed, modified or unmodified, for any purpose, provided     #
# that this copyright notice is retained verbatim in all copies and  #
# no attempt is made to obscure the authorship of this file.  If you #
# distribute any modified versions, I ask, but do not require, that  #
# you clearly mark any changes you make as such and that you provide #
# your users with instructions for getting the original sources.     #
######################################################################

######################################################################
# jbr:init - basic initialisation
######################################################################

proc jbr:init {} {
  j:jstools_init jnewbrowser		;# prefs, libraries, bindings...
  
  global COLDIR				;# per-column list of directories
  					;# $COLDIR(w) is the dir w displays
  set COLDIR(A) 0			;# make sure it's an array
  
  global WINDIR				;# per-window list of directories
  					;# $WINDIR($w) is dir in win $w
  set WINDIR(A) 0			;# make sure it's an array
}

######################################################################
# jbr:browse - action of double-click; cd if directory, else view
######################################################################

proc jbr:browse { w } {
  set filename [lindex [jbr:getfiles $w] 0]
  if [file isdirectory $filename] {
    jbr:cd $w $filename
  } else {
    jbr:cmd:view $w
  }
}

######################################################################
# jbr:new_window_name - get an unused name for a window
######################################################################

proc jbr:new_window_name {} {
  set i 0
  while {[winfo exists .jbrowser$i]} {
    incr i
  }
  return .jbrowser$i
}

######################################################################
# jbr:refresh w - redisplay contents of window
#   really need to do this ONLY when necessary!  add heuristics!
######################################################################

proc jbr:refresh {w} {
  jbr:fill_window $w [pwd]
}

######################################################################
# jbr:column_path w - return the path of the (single) sel'n in column $w
######################################################################

proc jbr:column_path { w } {
  global COLDIR
  
  set selindex [$w curselection]
  if {"x$selindex" == "x"} {
    # no selection, so return empty list:
    return {}
  } else {
    set filename [$w get $selindex]	;# needs to be more elaborate
  }
  
  # $w starts out being .some.path.lb; get .some.path:
  set frame [winfo parent $w]		;# breaks on main wish window
  
  set dir $COLDIR($frame)
  if {"x$dir" == "x/"} {
    return "/$filename"
  } else {
    return "$dir/$filename"
  }
}

######################################################################
# jbr:cd w dir - change directory in a window
#   just a first hack - needs to get initial directory from window
#   or column - or should it take only absolute paths?
#   more complicated, because we might be clicking on some column 
#   other than the last.
######################################################################

proc jbr:cd {w dir} {
  cd $dir
  jbr:refresh $w
}

######################################################################
# jbr:pwd w - get current directory for window
######################################################################

proc jbr:pwd { w } {
  return [pwd]
}

######################################################################
# jbr:attempt - attempt a Unix command and report an error on failure
######################################################################
# really ought to display output only if it's non-null
#
proc jbr:attempt { cmd } {
  if [catch [format "exec %s" $cmd] output] then {
    if [expr {[string length $output] < 80}] then {
      j:alert -text \
        "The command\n    $cmd\n failed with the following output:\n\n$output"
    } else {
      jbr:more {Output of failed command} \
        "The command\n\t$cmd\nfailed with the following output:\n\n$output"
    }
  }
  return $output
}

######################################################################
# jbr:getfiles w - get files currently selected in $w
######################################################################

proc jbr:getfiles { w } {
  set result {}
  set dir [jbr:pwd $w]
  
  foreach index [$w.col0.lb curselection] {
    set file [$w.col0.lb get $index]
    lappend result "$dir/$file"
  }
  
  return $result
}


