# ~/.tk/edittkmodes/mail-mode.tcl - mode for composing mail
######################################################################

j:ldb:set_defaults {
  {menu:mail {Mail} 0}
  {mode:mail:insert_sig {Append Signature} 7}
    {SHORT-mode:mail:insert_sig {Sign}}
  {mode:mail:delete_sig {Delete Signature} 1}
    {SHORT-mode:mail:delete_sig {Unsign}}
  
  {{Help on mail Mode} {Help on `mail' Mode}}
}

proc mode:mail:init { t } {
  global JEDIT_MODEPREFS
  
  j:read_prefs -array JEDIT_MODEPREFS -prefix mail \
    -directory ~/.tk/jeditmodes -file mail-defaults {
    {textfont default}
    {textwidth 80}
    {textheight 24}
    {textwrap char}
    {sabbrev 0}
    {dabbrev 0}
    {autobreak 1}
    {autoindent 0}
    {savestate 0}
    {buttonbar 1}
    {buttons {
      jedit:cmd:done
      mode:mail:delete_sig
      mode:mail:insert_sig
    }}
    {docs {
      -
      {{Help on mail Mode} {jeditmodes/mail-mode.jdoc}}
    }}
    {menu,editor 1}
    {menu,file 1}
    {menu,edit 1}
    {menu,prefs 0}
    {menu,abbrev 1}
    {menu,filter 1}
    {menu,format 0}
    {menu,display 0}
    {menu,mode1 1}
    {menu,mode2 1}
    {menu,user 1}
  }
}

######################################################################
# more procedures:

# delete the signature if it exists (and is tagged so):

j:command:register mode:mail:delete_sig {Remove Signature}
proc mode:mail:delete_sig { t } {
  catch {
    $t delete sig.first end
  }
}

j:command:register mode:mail:insert_sig {Append Signature}
proc mode:mail:insert_sig { t } {
  global env
  mode:mail:delete_sig $t
  set end [$t index end]
  $t insert end "\n"
  $t insert end [exec cat $env(HOME)/.signature]
  $t insert end "\n"
  $t tag add sig $end end
  $t tag configure sig -font {-*-courier-bold-r-normal--10-100-*}
  $t tag lower sig
}

######################################################################
# define the Mail menu:
######################################################################

proc mode:mail:mkmenu1 { menu t } {
  j:menu:menubutton $menu $menu.m menu:mail
  
  j:menu:commands $menu.m $t {
    mode:mail:insert_sig
    mode:mail:delete_sig
    jedit:cmd:done
  }
}


