# mh-mode.tcl - mode for composing mail in MH
######################################################################

j:ldb:set_defaults {
  {menu:mh {MH} 0}
  {mode:mh:start_reply {Start MH Reply} 6 <Meta-Key-2>}
    {SHORT-mode:mh:start_reply {Insert @}}
  {mode:mh:insert_sig {Append Signature}}
    {SHORT-mode:mh:insert_sig {Sign}}
  {mode:mh:delete_sig {Remove Signature}}
    {SHORT-mode:mh:delete_sig {Unsign}}
  {mode:mh:whom {List Recipients} 0 <Meta-Key-7>}
    {SHORT-mode:mh:whom {Whom}}
  {mode:mh:border {Insert Border} 7 <Meta-Key-8>}
    {SHORT-mode:mh:border {Border}}
  
  {mh_pref:mh_tab_headers {Tab to Headers}}
  
  {{Recipients} {Recipients}}
  
  {{Help on mh Mode} {Help on `mh' Mode}}
}

proc mode:mh:init { t } {
  global JEDIT_MODEPREFS
  
  j:read_prefs -array JEDIT_MODEPREFS -prefix mh \
    -directory ~/.tk/jeditmodes -file mh-defaults {
    {textfont default}
    {textwidth 80}
    {textheight 24}
    {textwrap char}
    {sabbrev 0}
    {dabbrev 0}
    {autobreak 1}
    {autoindent 0}
    {savestate 0}
    {buttonbar 1}
    {buttons {
      jedit:cmd:done
      mode:mh:border
      mode:mh:whom
      mode:mh:insert_sig
      mode:mh:start_reply
    }}
    {docs {
      -
      {{Help on mh Mode} {jeditmodes/mh-mode.jdoc}}
    }}
    {menu,editor 1}
    {menu,file 1}
    {menu,edit 1}
    {menu,prefs 0}
    {menu,abbrev 1}
    {menu,filter 1}
    {menu,format 0}
    {menu,display 0}
    {menu,mode1 1}
    {menu,mode2 1}
    {menu,user 1}
    {mh_tab_headers 1}
  }
  
  # catch {$t tag configure header -background LemonChiffon}
  $t tag configure header -relief flat		;# just to create it
  $t tag lower header
  catch {$t tag configure sig -font {-*-courier-bold-r-normal--10-100-*}}
  $t tag lower sig
  
  j:tk3 {
    bind $t <Double-Tab> "mode:mh:to_body $t"
    bind $t <Tab> "mode:mh:next_header $t"
  }
  j:tk4 {
    bind $t <Double-Tab> "mode:mh:to_body $t; break"
    bind $t <Tab> "mode:mh:next_header $t; break"
  }
}

######################################################################
# special hooks:

proc mode:mh:post_read_hook { filename t } {
  set separator {}
  if [regexp -indices "\n-*\n" [$t get 0.0 end] separator] {
    set headerend [lindex $separator 0]
    $t tag add header 0.0 "0.0 + $headerend chars + 1 char"
  }
}

proc mode:mh:to_body { t } {
  global JEDIT_MODEPREFS
  if $JEDIT_MODEPREFS(mh,mh_tab_headers) {
    $t mark set insert end
    $t yview -pickplace insert
  } else {
    jedit:tabkey $t
  }
}

# BUG - doesn't handle multi-line headers.

proc mode:mh:next_header { t } {
  global JEDIT_MODEPREFS
  if $JEDIT_MODEPREFS(mh,mh_tab_headers) {
    if [$t compare header.last <= insert] {
      $t mark set insert 1.0
    }
    
    set headpart [$t get insert header.last]
    
    set regex [format {(^|%s)[A-Za-z-]*:[ %s]*} "\n" "\t"]
    if [regexp -indices -- $regex $headpart indices] {
      $t tag remove sel 1.0 end
      set valuestart [expr [lindex $indices 1] + 1]
      $t mark set hdrfrom "insert + $valuestart chars"
      $t tag add sel hdrfrom {hdrfrom lineend}
      $t mark set insert {hdrfrom lineend}
      $t yview -pickplace insert
    } else {
      # assume we're in the last header field, so jump to body
      mode:mh:to_body $t
    }
  } else {
    jedit:tabkey $t
  }
}

######################################################################
# define the MH menu:
######################################################################

proc mode:mh:mkmenu1 { menu t } {
  j:menu:menubutton $menu $menu.m menu:mh
  j:menu:checkbuttons $menu.m [list \
    [list mh_pref:mh_tab_headers JEDIT_MODEPREFS(mh,mh_tab_headers)] \
  ]
  j:menu:commands $menu.m $t {
    -
    mode:mh:start_reply
    mode:mh:insert_sig
    mode:mh:delete_sig
    mode:mh:whom
    mode:mh:border
    -
    jedit:cmd:done
  }
  
  bind $t <Meta-Key-2> "mode:mh:start_reply $t"
  bind $t <Meta-Key-7> "mode:mh:whom $t"
  bind $t <Meta-Key-8> "mode:mh:border $t"
}

######################################################################
# command procedures:

j:command:register mode:mh:border {Insert Border}
proc mode:mh:border { t args } {
  j:text:insert_string $t \
    "     * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\n"
}

# delete the signature if it exists (and is tagged so):

j:command:register mode:mh:delete_sig {Remove Signature}
proc mode:mh:delete_sig { t args } {
  catch {
    $t delete sig.first end
  }
}

j:command:register mode:mh:insert_sig {Append Signature}
proc mode:mh:insert_sig { t args } {
  global env
  mode:mh:delete_sig $t
  set end [$t index end]
  $t insert end "\n"
  $t insert end [exec cat $env(HOME)/.signature]
  $t insert end "\n"
  $t tag add sig $end end
}

j:command:register mode:mh:start_reply {Start MH Reply}
proc mode:mh:start_reply { t args } {
  set reply [exec cat "@" | sed {1,/^$/d} | \
    sed {s/^>/  /} | sed {s/^/  /}]
  $t insert end $reply
}

j:command:register mode:mh:whom {List Recipients}
proc mode:mh:whom { t args} {
  jedit:cmd:save $t
  set filename [jedit:get_filename $t]
  j:more -height 10 -width 60 -title [j:ldb {Recipients}] \
    -text [exec whom -check $filename]
}





