proc HelpDiagram {} {
  global work_dir
  set w .help
  set line_col red
  set text_col red
  catch {destroy $w}
  toplevel $w
  wm geom $w +0+0
  canvas $w.c -height 400 -width 550
  pack $w.c -side top
  $w.c create bitmap 130 40 -an nw -bitmap @${work_dir}/ex_screen.bm
  $w.c create line 54 172 136 138 -arrow last -width 2 -fill $line_col
  $w.c create text 54 172 -text "host button" -anch n -fill $text_col
  $w.c create line 204 318 224 338 331 338 341 358 351 338 464 338 484 318\
    -smooth 1 -width 2 -fill $line_col
  $w.c create line 488 126 508 146 508 196 518 206 508 216 508 267 488 287\
    -smooth 1 -width 2 -fill $line_col
  $w.c create line 104 333 222 294 -arrow last -width 2 -fill $line_col
  $w.c create text 104 333 -anch w -text "scrollbar" -fill $text_col -an n
  $w.c create text 340 359 -anch n -text "reservation grid" -fill $text_col
  $w.c create line 114 116 232 115 -arrow last -width 2 -fill $line_col
  $w.c create text 114 116 -an e -text "beginning and ending date for week"\
    -width 90 -just right -fill $text_col
  $w.c create line 109 217 232 159 -arrow last -wid 2 -fill $line_col
  $w.c create text 109 217 -an e -text "a reservation" -fill $text_col
  $w.c create rect 201 205 233 223 -fill blue
  $w.c create line 115 244 199 220 -arrow last -width 2 -fill red
  $w.c create text 115 244 -text "weekend" -an ne -fill red
  $w.c create line 117 78 239 94 -arrow last -width 2 -fill red
  $w.c create text  117 78 -an e -text "Calendar Week" -fill red
  $w.c create rect 338 165 345 184 -fill green
  $w.c create rect 346 165 353 184 -fill yellow  
  $w.c create line 278 33 338 166 -width 2 -fill $line_col -arrow last
  $w.c create text 278 33 -text "click here for morning" -fill $text_col -an se
  $w.c create line 351 166 374 30 -width 2 -fill $line_col -arrow first
  $w.c create text 374 30 -text "click here for afternoon" -fill $text_col -an\
    sw
  button $w.b -text "Good-Bye" -rel rais -command "destroy $w"
  pack $w.b -side top -fill x
}
proc HelpHints {} {
  set w .helphints
  set font -Adobe-Times-Medium-R-Normal-*-180-*
  set lab_col blue
  catch {destroy $w}
  toplevel $w
  wm geo $w -0+0
  label $w.lab1 -text "To display a reservation..." -rel groove -fg $lab_col
  message $w.msg1 -width 500 -font $font -text \
  {In order to get information about a reservation, click on the reservation\
   with MB1  (mouse-button-1).}
  label $w.lab2 -text "To display Stammdaten..." -rel groove -fg $lab_col
  message $w.msg2 -width 500 -font $font -text\
  {Select choice "Display" from the pulldown menu "Hosts". Choose a host from\
   from the list and click on "OK"}
  label $w.lab3 -text "To make changes..." -rel groove -fg $lab_col
  message $w.msg3a -width 500 -font $font -text\
  {You must lock the host by clicking on the host button.\
   When you are finished, click on the host button again to unlock the host\
   so that others can reserve it.}
  message $w.msg3b -width 500 -font $font -foreground red -text\
  {If you have not unlocked the host after 2 minutes,\
   it will be automagically unlocked. All changes you made (reservations,\
   Stammdaten) will be saved with the exception of a reservation that has not\
   been confirmed.}
  label $w.lab4 -text "Making or deleting a reservation..." -rel groove -fg\
    $lab_col
  message $w.msg4 -width 500 -font $font -text\
  {Now you can make a reservation by clicking and holding MB1 on\
   a non-reserved square, and dragging over the days to reserve.  To delete\
   a reservation, click MB3 on a reservation.}
  label $w.lab5 -text "Changing Stammdaten..." -rel groove -fg $lab_col
  message $w.msg5 -width 500 -font $font -text\
  {Lock the host in question and then select the choice "Change" from the\
   pulldown menu "Hosts." Now you have a dialog window}
  label $w.lab6 -text "Selecting days..." -rel groove -fg $lab_col
  message $w.msg6 -width 500 -font $font -text\
  {When selecting either the beginning or the end of a reservation,\
   choose either the left or right half of the square to select respectively\
   either morning or afternoon on the corresponding day.}
  pack $w.lab1 $w.msg1 $w.lab2 $w.msg2 $w.lab3 $w.msg3a $w.msg3b $w.lab4\
    $w.msg4 $w.lab5 $w.msg5 $w.lab6 $w.msg6 -side top -fill x
  button $w.b -text "Good-Bye" -rel raised -command "destroy $w"
  pack $w.b -side top -fill x
}
