#
# ShowHelp: display a text window on the help text
#
proc ShowHelp {} {
    global ReplayData
    set w .replay.helpWindow
    if [winfo exists $w] {
        wm deiconify $w
    } else {
        toplevel $w
        wm minsize $w 10 10
        wm geometry $w "+0+0"
        button $w.done -text Done -command "wm withdraw $w"
        pack $w.done -side bottom
        scrollbar $w.yscroll -orient vertical -relief sunken -bd 2 \
            -command "$w.text yview"
        pack $w.yscroll -side right -fill y
        text $w.text -width 80 -height 16 -relief sunken -bd 2 \
            -yscrollcommand "$w.yscroll set"
        pack $w.text -side left -fill both -expand yes
        $w.text insert end $ReplayData(HelpText)
    }
}
proc CreateHelpFile {} {
    global ReplayData
    set ReplayData(HelpText) {\
                 TK RECORD AND REPLAY FACILITY
                     Version: Beta 0.40
                      19 December 1994
AUTHOR:
    Charlie Crowley
    Computer Science Department
    Univ. Of New Mexico
    crowley@cs.unm.edu

        Comments and bug reports are very welcome.

OVERVIEW: This file contains tcl/tk code that allows you to record a
    script of actions and then replay them.  You can save a script
    and later reload and replay it.  This would be useful for creating
    domonstrations of your software.  You can add comments to the
    demonstration that will display at the proper time.  The demonstration
    is replayed at the same rate as you recorded it (or you can request
    that it be played faster).

HOW TO RECORD A DEMONSTRATION:
  1. Start the tcl/tk program you want to record.
  2. Start TkReplay with the command:
      wpwish -f main.tcl (in the TkReplay directory).
  3. Choose FILE/Connect to app.. to connect the replay program to the
      program you are recoding.  Choose the Tk interpreter of the program
      you are recording.  Wait about 15 seconds for it to connect.
  4. Press "Record" to start recording a script.
  5. As you record the listboxes will display all the recorded events as you
     generate them.
  6. If you want to add a comment to the script, press the "Comment"
     button and type in the comment.  Press "Done" when you are finished
     with the comment.
  7. When you are done, press "Stop" to end recording.
  8. Save your recording by choosing the "Save..." command on the FILE menu.
     Choose a file name to save to.  It WILL write over and exiting file so
     be careful.

HOW TO REPLAY:
  1. Start the tcl/tk program you want to record.
  2. Start TkReplay with the command:
      wpwish -f main.tcl (in the TkReplay directory).
  3. Choose FILE/Connect to app.. to connect the replay program to the
      program you are recoding.  Choose the Tk interpreter of the program
      you are recording.  Wait about 15 seconds for it to connect.
  4. Load your recording by choosing the "Load..." command on the FILE menu.
     Choose a file name to load from.
  5. Press "Play" to play out the script. (Or "PlayFast" to replay at
      maximum speed.)

     The script will be replayed at the same rate that you recorded it.
     Actually it will be slower since the record/replay mechanism takes
     some extra time.  When you get to a comment you must press "Okay"
     to continue.  You can see the events in the listboxes as they are
     being replayed.  A small window containing a red arrowhead points
     to the widget in which an event is happening.  Notice that everything
     you did is recorded, even the extraneous enter and exit events that
     you generate when you move the mouse over widgets.  The arrow window
     does not point to widgets if the event is an enter, exit or focus event.
     This makes the replay go a little more smoothly.
     

HOW TO EDIT THE SCRIPT:
    The script is an ASCII text file that you can edit with any text editor.
    Each event is on a separate line.  Each event has three fields:
    1. The delay before the event (in 10th of a second).
    2. The "subscript" of the event that is used internally.  This consists
       of the class of binding that caused the event (All, Class or Widget),
       the name of the widget and the name of the event.  These should be
       fairly easy to read.
    3. The %-substitutions for the event.  These are the details of the
       X event.
    There are two kinds of obvious editing.  First you can change the
    delays between events just by changing the numbers.  Second you can
    eliminate an event just by deleting the line.

KNOWN PROBLEMS:
    1. It slows things up noticably.
    2. Unbinding does not work.
    3. Canvas bindings do nto work very well.
    4. The script does not know about window manager commands.  Moving the
        windows will not affect things but if you resize the windows with
        the window manager the script may not replay properly.
}
}



