/* scrinfo.h
***************************************************************************** 
expecTerm version 1.0 beta
Mark Weissman
Christopher Matheus
Copyright 1992 by GTE Laboratories Incorporated.

Portions of this work are in the public domain.  Permission to use,
copy, modify, and distribute this software and its documentation for
any purpose and without fee is hereby granted, provided that the above
copyright notice appear in all copies and that both the copyright
notice and warranty disclaimer appear in supporting documentation, and
that the names of GTE Laboratories or any of their entities not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

GTE disclaims all warranties with regard to this software, including
all implied warranties of merchantability and fitness for a particular
purpose, even if GTE Laboratories Incorporated knows about the
purpose.  In no event shall GTE be liable for any special, indirect or
consequential damages or any damages whatsoever resulting from loss of
use, data or profits, whether in an action of contract, negligence or
other tortuous action, arising out of or in connection with the use or
performance of this software.

This code is based on and may include parts of Don Libes' expect code:
  expect written by: Don Libes, NIST, 2/6/90
  Design and implementation of expect was paid for by U.S. tax
  dollars.  Therefore it is public domain.  However, the author and NIST
  would appreciate credit if this program or parts of it are used.
******************************************************************************/

#define REL_ROWMIN_DEFAULT 0
#define REL_ROWMAX_DEFAULT 0
#define REL_COLMIN_DEFAULT 0
#define REL_COLMAX_DEFAULT 0

#define SCR_CONTENTS 'c'
#define SCR_ATTRIBUTES 'a'
#define SCR_SERIAL 's'

#define SCR_RELATIVE 'r'
#define SCR_ABSOLUTE 'a'

#define SCR_IGNORE 'i'
#define SCR_NORMAL 'n'

#define SCR_BREAKS 'b'
#define SCR_NOBREAKS 'n'

#define SCR_DEFAULT_NON_PRINT_CHAR '\0'

/* TCL variable names */
#define CLIP_ROWMIN_VAR "clip_row_min" 
#define CLIP_ROWMAX_VAR "clip_row_max"
#define CLIP_COLMIN_VAR "clip_col_min"
#define CLIP_COLMAX_VAR "clip_col_max"

typedef struct ScreenRegionStruct {
    char match_type;		/* SCR_SERIAL, SCR_ATTRIBUTES, SCR_CONTENTS */
    int rowmin;			/* minimum row */
    int rowmax;			/* maximum row */
    int colmin;			/* minimum column */
    int colmax;			/* maximum column */
    
    int relrowmin;		/* minimum relative row */
    int relrowmax;		/* maximum relative row */
    int relcolmin;		/* minimum relative column */	
    int relcolmax;		/* maximum relative column */

    char breaksp;
    char casep;
    char relrowp;		/* relative row flag SCR_RELATIVE, SCR_ABSOLUTE */
    char relcolp;		/* relative column flag SCR_RELATIVE, SCR_ABSOLUTE */
    char non_print_char;	/* char to display for non-asci characters */
} ScreenRegion;

extern char *get_screen_region();
extern void init_screen_region();
extern int parse_screen_argument();
extern void init_scr_region_variables();
