/*
 * tcl_ls.c
 *
 *	The ls command of Tcl useable under Windows !
 */

#ifndef _Windows
#define	_export
#endif

#include	<tcl.h>
#include	<string.h>
#include	<dirent.h>

static int	Tcl_ls _ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp,
	int argc, char **argv));
static int Tcl_system _ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp,
	int argc, char **argv));

static int
Tcl_ls (ClientData dummy, Tcl_Interp *interp, int argc, char **argv)
{
 DIR *dir_p, *is_dir;
 struct dirent *dirent_p;
 char *dirname;
 char f_name[260];

	if (argc == 2)
		dirname = argv[1];
	if (argc == 1)
		dirname = ".";

	dir_p = opendir(dirname);
	if (dir_p != NULL)
	{
		Tcl_ResetResult(interp);
		do
		{
			dirent_p = readdir(dir_p);
			if (dirent_p == NULL) break;
			f_name[0] = '\0';
			strcat(f_name, dirname);
#ifdef _Windows
			strcat(f_name, "\\");
#else
			strcat(f_name, "/");
#endif
			strcat(f_name, dirent_p->d_name);
			if ((is_dir = opendir(f_name)) != NULL)
			{
				closedir(is_dir);
				Tcl_AppendResult(interp, dirent_p->d_name, "/\n", NULL);
			}
			else
				Tcl_AppendResult(interp, dirent_p->d_name, "\n", NULL);
		} while (1);
		closedir(dir_p);
	}	return TCL_OK;
}

#include	<stdlib.h>
static int
Tcl_system (ClientData dummy, Tcl_Interp *interp, int argc, char **argv)
{
 char cmd[1024];
 int i = 1;
	cmd[0] = '\0';
	while (--argc)
	{
		strcat(cmd, argv[i++]);
		strcat(cmd, " ");
	}
	if (cmd[0] != '\0') system(cmd);
	return TCL_OK;
}

/*
 *Tcl_ls_Init - the library initialization file for the extension
 */
int _export
Tcl_ls_Init(Tcl_Interp *interp)
{
	Tcl_CreateCommand(interp, "ls", Tcl_ls, (ClientData) 0,
		(Tcl_CmdDeleteProc *)NULL);
	Tcl_CreateCommand(interp, "system", Tcl_system, (ClientData) 0,
		(Tcl_CmdDeleteProc *)NULL);
	return TCL_OK;
}
