/*
 * Init the NeoSoft Tcl extensions
 *
 *
 * $Id: neoPkgInit.c,v 1.1.1.1 1999/03/31 20:34:37 damon Exp $
 *
 */

#include "neo.h"


/*
 *----------------------------------------------------------------------
 *
 * Neo_Init --
 *
 *      This package init routine adds in the neosoft stuff.
 *
 * Results:
 *      Returns a standard Tcl completion code, and leaves an error
 *      message in interp->result if an error occurs.
 *
 * Side effects:
 *      Loads in our stuff.
 *
 *----------------------------------------------------------------------
 */

int
Neo_Init(interp)
    Tcl_Interp *interp;         /* Interpreter for application. */
{
    char *libDir;
    if (Tcl_GetVar(interp, "neo_library", TCL_GLOBAL_ONLY) == NULL) {
	/*
	 * A library directory hasn't already been set, so figure out
	 * which one to use.
	 */
	libDir = getenv("NEO_LIBRARY");
	if (libDir == NULL) {
	    libDir = NEO_LIBRARY;
	}
	Tcl_SetVar(interp, "neo_library", libDir, TCL_GLOBAL_ONLY);
	Tcl_SetVar(interp, "auto_path", libDir, TCL_GLOBAL_ONLY | TCL_APPEND_VALUE | TCL_LIST_ELEMENT);
    }

#ifdef NEOSOFT_TCL_ENCRYPTION
    if (NeoSoft_InitEncrypt (interp) == TCL_ERROR) {
        return TCL_ERROR;
    }
#endif

    /* NeoSoft Web Extensions */
    if (Neo_XwwwInit (interp) == TCL_ERROR) {
        return TCL_ERROR;
    }

#ifdef NEO_DB
    if (Neo_dbInit (interp) == TCL_ERROR) {
        return TCL_ERROR;
    }
#endif

#ifdef USE_GD
    if (Gd_Init (interp) == TCL_ERROR) {
        return TCL_ERROR;
    }
    Tcl_StaticPackage(interp, "Gd", Gd_Init, NULL);
#endif

#ifdef CUTE
    if (Cute_InitComm (interp) == TCL_ERROR) {
        return TCL_ERROR;
    }
#endif

    if (Neo_initGeneral (interp) == TCL_ERROR) {
        return TCL_ERROR;
    }

#ifdef NEO_LDAP
    if (Neo_initLDAP (interp) == TCL_ERROR) {
        return TCL_ERROR;
    }
#endif

    if (TclX_InitKDebug (interp) == TCL_ERROR) {
        return TCL_ERROR;
    }

#ifdef NEO_TELEPHONY
    if (Neo_initTelephony (interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
#endif

    /*
     * from tclXcomma.c
     */
    Tcl_CreateObjCommand (interp, 
			  "comma_split",
			   NeoX_CommaSplitObjCmd,
			   (ClientData) 0,
			   (Tcl_CmdDeleteProc *)NULL);

    Tcl_CreateObjCommand (interp, 
			  "comma_join", 
			  NeoX_CommaJoinObjCmd,
                          (ClientData) 0, 
			  (Tcl_CmdDeleteProc *)NULL);

    Tcl_CreateCommand (interp, "lassign_array", Tcl_LassignArrayCmd,
                       (ClientData) NULL, (void (*)()) NULL);
    Tcl_CreateCommand (interp, "lassign_fields", Tcl_LassignFieldsCmd,
                       (ClientData) NULL, (void (*)()) NULL);

    return Tcl_PkgProvide (interp, "Neo", "8.0.3");
}

