#
# PROPERTY LIST STORAGE AND RETRIEVAL
#

#
# for the trusted interp
#

proc dbtransaction {code args} {
    global errorCode parallelDir webenv

    setup_data_access

    set str "$webenv(SCRIPT_FILENAME)_[pid]_[clock seconds]"
    set seed "tr_[string range [md5 $str] 0 11]"
    set dir [file join $parallelDir $seed]

    file mkdir $dir
    db appinit $dir
    db transaction eval $code
    db appexit
    file delete -force $dir
}

proc dbfetch {database id arrayName args} {
    global errorCode

    setup_data_access

    set search [lsearch -exact $args "-singleVar"]
    if {$search > -1} {	
	set singleVar "-singleVar"
	set args [lreplace $args $search $search]
    } else {
	set singleVar {}
    }

    if {[cindex $args 0] == "-"} {import_keyvalue_pairs data $args}
    if ![info exists data(project)] {set data(project) {}}
    db_name_check $database db dbFileName $data(project)

    if {[catch {db open $dbFileName hash cl 0664} db] == 1} {
	create_user_dir db
      if {[catch {db open $dbFileName hash cl 0664} db] == 1} {
	   return -code error "$dbFileName: $errorCode"
      }
    }

    db get $db $id list
    db close $db

    set haveData [expr ![lempty $list]]

    if {$singleVar == "-singleVar"} {
	set $arrayName $list
    } else {
	upvar $arrayName array
	array set array $list
    }

    return $haveData
}

proc dbstore {database id arrayName args} {
    global errorCode

    setup_data_access

    set search [lsearch -exact $args "-singleVar"]
    if {$search > -1} {	
	set list $arrayName
	set args [lreplace $args $search $search]
    } else {
	upvar $arrayName array
	set list [array get array]
    }

    if {[cindex $args 0] == "-"} {import_keyvalue_pairs data $args}
    if ![info exists data(project)] {set data(project) {}}
    db_name_check $database db dbFileName $data(project)
    create_user_dir db

    if {[catch {set db [db open $dbFileName hash cwL 0664]}] == 1} {
	if {[lrange $errorCode 0 1] != "POSIX ENOENT"} {
	    return -code error "$dbFileName: $errorCode"
	} else {
	    set db [db open $dbFileName hash ctwL 0664]
	}
    }
    db put $db $id $list
    db close $db
    return
}

#
# For the safe interp
#
SAFE_proc_and_alias dbfetch {safeInterp database id arrayName args} {
    global errorCode errorInfo

    setup_data_access

    set search [lsearch -exact $args "-singleVar"]
    if {$search > -1} {	
	set singleVar "-singleVar"
	set args [lreplace $args $search $search]
    } else {
	set singleVar {}
    }

    if {[cindex $args 0] == "-"} {import_keyvalue_pairs data $args}
    if ![info exists data(project)] {set data(project) {}}
    db_name_check $database db dbFileName $data(project)

    if {[catch {db open $dbFileName hash cl 0664} db] == 1} {
      create_user_dir db
      if {[catch {db open $dbFileName hash cl 0664} db] == 1} {
	    error "$dbFileName: $errorCode" $errorInfo
      }
    }

    db get $db $id list
    db close $db

    set haveData [expr ![lempty $list]]

    if {$singleVar == "-singleVar"} {
	$safeInterp eval set $arrayName [list $list]
    } else {
	$safeInterp eval array set $arrayName [list $list]
    }

    return $haveData
}

SAFE_proc_and_alias dbstore {safeInterp database id arrayName args} {
    global errorCode

    setup_data_access

    set search [lsearch -exact $args "-singleVar"]
    if {$search > -1} {	
	set list $arrayName
	set args [lreplace $args $search $search]
    } else {
	set list [$safeInterp eval array get $arrayName]
    }

    if {[cindex $args 0] == "-"} {import_keyvalue_pairs data $args}
    if ![info exists data(project)] {set data(project) {}}
    db_name_check $database db dbFileName $data(project)

    if {[catch {set db [db open $dbFileName hash cwL 0664]}] == 1} {
	create_user_dir db
      if {[catch {set db [db open $dbFileName hash cwL 0664]}] == 1} {
	    return -code error "$dbFileName: $errorCode"
      }
    }
    db put $db $id $list
    db close $db
    return
}

SAFE_proc_and_alias dbdelkey {safeInterp database id args} {
    global errorCode

    setup_data_access

    if {[cindex $args 0] == "-"} {import_keyvalue_pairs data $args}
    if ![info exists data(project)] {set data(project) {}}
    db_name_check $database db dbFileName $data(project)

    if {[catch {set db [db open $dbFileName hash cw 0664]}] == 1} {
	    return 0
    }
    set result [db del $db $id]
    db close $db
    return $result
}

SAFE_proc_and_alias dbexists {safeInterp database args} {
    setup_data_access
    if {[cindex $args 0] == "-"} {import_keyvalue_pairs data $args}
    if ![info exists data(project)] {set data(project) {}}
    db_name_check $database db dbFileName $data(project)

    return [file readable $dbFileName]
}

SAFE_proc_and_alias dbkeys {safeInterp database args} {
    global errorCode

    setup_data_access

    if {[cindex $args 0] == "-"} {
	    import_keyvalue_pairs data $args
    } else {
	    set data(pattern) [lindex $args 0]
    }

    if ![info exists data(project)] {set data(project) {}}
    db_name_check $database db dbFileName $data(project)

    if {![info exists data(pattern)] || $data(pattern) == {}} {
	    set data(pattern) *
    }

    if {[catch {set db [db open $dbFileName hash c 0664]}] == 1} {
	if {[lrange $errorCode 0 1] != "POSIX ENOENT"} {
	    return -code error "$dbFileName: $errorCode"
	} else {
	    return ""
	}
    }
    set keys ""
    db searchall $db key -glob $data(pattern) {
	lappend keys $key
    }
    db close $db

    return $keys
}

SAFE_proc_and_alias dbfiles {safeInterp args} {
    global parallelDir errorCode
    setup_data_access

    if {[cindex $args 0] == "-"} {
	    import_keyvalue_pairs data $args
    } else {
	    set data(pattern) [lindex $args 0]
    }

    if {![info exists data(pattern)] || $data(pattern) == {}} {
	    set data(pattern) *
    }

    set db "${parallelDir}db"
    if [info exists data(project)] {
	    append db "/$data(project)"
    }
    append db "/$data(pattern).db"

    set result {}
    foreach file [glob -nocomplain $db] {
	lappend result [file root [file tail $file]]
    }
    return $result
}

SAFE_proc_and_alias for_db {safeInterp args} {
    global errorCode errorInfo

    setup_data_access

    set singleVar 0
    set search [lsearch -exact $args "-singleVar"]
    if {$search > -1} {	
	set singleVar 1
	set args [lreplace $args $search $search]
    }

    set data(project) {}
    set data(search) glob
    import_args_with_pairs data $args

    if {[llength $data(args)] > 4} {
	lassign $data(args) database keyVar arrayName pattern body
    } else {
	lassign $data(args) database keyVar arrayName body
	set pattern *
    }

    db_name_check $database db dbFileName $data(project)

    if {[catch {db open $dbFileName hash cl 0664} db] == 1} {
	create_user_dir db
	if {[catch {db open $dbFileName hash cl 0664} db] == 1} {
	    return -code error "$dbFileName: $errorCode" $errorInfo
	}
    }

    # They have opted to sort the keys.
    if [info exists data(sort)] {
	if ![info exists data(order)] {
	    set data(order) increasing
	}
	db searchall $db key -$data(search) $pattern {
	    lappend keys $key
	}
	set keys [lsort -$data(sort) -$data(order) $keys]
	foreach key $keys {
	    db get $db $key list
	    $safeInterp eval set $keyVar $key
	    if $singleVar {
		$safeInterp eval set $arrayName [list $list]
	    } else {
		$safeInterp eval array set $arrayName [list $list]
	    }
	    $safeInterp eval $body
	    if [info exists list] {unset list}
	}
	return
    }

    db searchall $db key -$data(search) $pattern {
	db get $db $key list
	$safeInterp eval set $keyVar $key
	if $singleVar {
	    $safeInterp eval set $arrayName [list $list]
	} else {
	    $safeInterp eval array set $arrayName [list $list]
	}
	$safeInterp eval $body
	if [info exists list] {unset list}
    }
    db close $db
}

proc db_include_counter {path {counter "default"}} {
    global NeoWebServerConf errorCode server

    if {![info exists NeoWebServerConf(UrlAccessCounter)]} {
        return ""
    }
    set dbFileName $NeoWebServerConf(UrlAccessCounter)
    if {[cindex $dbFileName 0] != "/"} {
        set dbFileName $server(SERVER_ROOT)/$dbFileName
    }
    if {[catch {db open $dbFileName hash cl 0664} db] == 1} {
	set dbDirName [file dirname $dbFileName]
	if {![file isdirectory $dbDirName]} {
	    file mkdir $dbDirName
	}
	if {[catch {db open $dbFileName hash cl 0664} db] == 1} {
	    error $errorCode
	}
    }

    db get $db $path valist
    db close $db

    if {![info exists valist] || ($valist == "")} {
        set valist 0
    }
    incr valist
    if {[catch {set db [db open $dbFileName hash cwL 0664]}] == 1} {
	return "uh oh"
	if {[lrange $errorCode 0 1] != "POSIX ENOENT"} {
	    return "even worse"
	    return -code error "$dbFileName: $errorCode"
	} else {
	    set db [db open $dbFileName hash ctwL 0664]
	}
    }
    db put $db $path $valist
    db close $db

    return $valist
}
