#
# Copyright (C) NeoSoft, All Rights Reserved.  See NeoWebScript LICENSE
# files with this distribution for conditions on use and redistribution.
#
# NeoWebScript [TM] development source code
#
# Tcl file that, when debugging is true, gets sourced every time a webpage 
# is pulled up that contains NeoWebScript server-side code. 
#
# If debugging is false, the file is loaded in only once by the
# "mother thread".
#
# $Id: devel.tcl,v 1.1.1.1 1999/03/31 20:53:26 damon Exp $
#

proc dump_request_stack {} {
    if ![www_request_info req] {
        error "impossible?  www_request_info failed for current record"
    }
    html "Dump of request stack" h2
    html "Cazart!  Something went wrong and you get to see all this cool stuff!"
    parray req

    foreach type "next prev main" {
        if {$req($type)} {
            for {set i 1} {[www_request_info $type $i nreq]} {incr i} { 
                html "$type $i" h2
                parray nreq
            }
        }
    }
}

#
# run the special code to setup whatever is loaded by the
# devel.tcl file.  It is expected that code in here that
# works will be migrated to init.tcl if it is found to be useful.
#
proc devel_setup {safeInterp} {
    $safeInterp alias neo_crypt neo_crypt
    $safeInterp alias comma_join comma_join
    $safeInterp alias comma_split comma_split
    $safeInterp alias md5 md5
    if ![interp issafe $safeInterp] {
	$safeInterp alias supervisor_data_access supervisor_data_access
    }
    $safeInterp alias persistent SAFE_persistent $safeInterp
    $safeInterp alias persistent SAFE_load_persistent $safeInterp
    install_tclx_procs $safeInterp
}

#
# hack to auto_load certain tclx commands
#
proc install_tclx_procs {safeInterp} {
    set tclxcommands [list lrmdups intersect intersect3 union]
    foreach command $tclxcommands {
	auto_load $command
        $safeInterp alias $command $command
    }
}

# Functions to impliment the persistent command
#
# Called from C
proc snapshot_persistent {} {
}

proc load_persistent {} {
}

# Called from Tcl

proc SAFE_persistent {safeInterp varName {varValue ""}} {
    global persistentInit
    load_cookies

    if {![info exists cookies(neoPersistentData)] && $persistentInit != 1} {
        set keyseed "[clock seconds] [clock format [clock seconds]] [pid] [id] $safeInterp $varName $varValue"
        set key [md5 $keyseed]

        neo_make_cookie neoPersistentData $key -days 30 -path /
        set persistentInit 1
    } else {
        set key $cookies(neoPersistentData)
    }

    dbfetch persDB $key_v val
    if [info exists $val] {
        if {$varValue == ""} {
            uplevel #0 "set $varName $val"
        } else {
            set valName $valValue
            dbstore persDB $key_v valName
        }
    }

    dbfetch persDB $key_a array
    if [info exists array($varName)] {
        if {$varValue == ""} {
            uplevel #0 "array set $varName [array get array($varName)]"
        } else {
            set array($varName) [uplevel "array get $varName"]
            dbstore persDB $key_a array
        }
    }
}

proc supervisor_data_access {uname} {
    global parallelDir webpageOwnerName
    if [info exists parallelDir] return
    global parallelUserBase
    set parallelDir $parallelUserBase/[cindex $uname 0]/$uname/
}
