/*
 * Copyright 1997 NeoSoft, Inc. All Rights Reserved
 * Author: Randy Kunkee
 * Permission to use for any purpose whatsoever is granted provided the
 * above notice is preserved.
 */
#include <stdio.h>
#include <ctype.h>
#include <pwd.h>
#if HAVE_SHADOW
#include <shadow.h>
#endif

#ifdef HAVE_SHADOW
main(int argc, char **argv)
{
    struct passwd *pwd;
    struct spwd *shadow;
    char *password;
    if (argc < 2)
	exit(1);
    if (isdigit(argv[1][0])) 
    {
	pwd = getpwuid(atoi(argv[1]));
	if (!pwd)
	    exit(1);
	shadow = getspnam(pwd->pw_name);
    } else {
	shadow = getspnam(argv[1]);
    }
    if (!shadow)
	exit(1);
    puts(shadow->sp_pwdp);
    exit (0);
}
#else
main(int argc, char **argv)
{
    struct passwd *pwd;
    if (argc < 2)
	exit(1);
    if (isdigit(argv[1][0])) 
	pwd = getpwuid(atoi(argv[1]));
    else
	pwd = getpwnam(argv[1]);
    if (pwd == NULL) 
	exit (1);
    puts(pwd->pw_passwd);
    exit (0);
}
#endif
