'\"
'\" Copyright (c) 1993-1998  Lucent Technologies, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: $Id: ensemble.n,v 1.1.1.1 1999/03/31 20:39:46 damon Exp $
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" SCCS: @(#) man.macros 1.9 97/08/22 18:50:59
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH ensemble n 3.0 itcl "[incr\ Tcl]"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
ensemble \- create or modify a composite command
.SH SYNOPSIS
\fBensemble \fIensName\fR ?\fIcommand arg arg...\fR?
.br
or
.br
\fBensemble \fIensName\fR {
.br
    \fBpart \fIpartName args body\fR
.br
    \fI...\fR
.br
    \fBensemble \fIpartName\fR {
.br
        \fBpart \fIsubPartName args body\fR
.br
        \fBpart \fIsubPartName args body\fR
.br
    \fI...\fR
    }
.br
}
.BE

.SH DESCRIPTION
.PP
The \fBensemble\fR command is used to create or modify a composite
command.  See the section \fBWHAT IS AN ENSEMBLE?\fR below for a
brief overview of ensembles.
.PP
If the \fBensemble\fR command finds an existing ensemble called
\fIensName\fR, it updates that ensemble.  Otherwise, it creates an
ensemble called \fIensName\fR.  If the \fIensName\fR is a simple name
like "foo", then an ensemble command named "foo" is added to the
current namespace context.  If a command named "foo" already exists
in that context, then it is deleted.  If the \fIensName\fR contains
namespace qualifiers like "a::b::foo", then the namespace path is
resolved, and the ensemble command is added that namespace context.
Parent namespaces like "a" and "b" are created automatically, as needed.
.PP
If the \fIensName\fR contains spaces like "a::b::foo bar baz", then
additional words like "bar" and "baz" are treated as sub-ensembles.
Sub-ensembles are merely parts within an ensemble; they do not have
a Tcl command associated with them.  An ensemble like "foo" can
have a sub-ensemble called "foo bar", which in turn can have a
sub-ensemble called "foo bar baz".  In this case, the sub-ensemble
"foo bar" must be created before the sub-ensemble "foo bar baz"
that resides within it.
.PP
If there are any arguments following \fIensName\fR, then they are
treated as commands, and they are executed to update the ensemble.
The following commands are recognized in this context:  \fBpart\fR
and \fBensemble\fR.
.PP
The \fBpart\fR command defines a new part for the ensemble.
Its syntax is identical to the usual \fBproc\fR command, but
it defines a part within an ensemble, instead of a Tcl command.
If a part called \fIpartName\fR already exists within the ensemble,
then the \fBpart\fR command returns an error.
.PP
The \fBensemble\fR command can be nested inside another \fBensemble\fR
command to define a sub-ensemble.

.SH "WHAT IS AN ENSEMBLE?"
The usual "info" command is a composite command--the command name
\fBinfo\fR must be followed by a sub-command like \fBbody\fR or \fBglobals\fR.
We will refer to a command like \fBinfo\fR as an \fIensemble\fR, and to
sub-commands like \fBbody\fR or \fBglobals\fR as its \fIparts\fR.
.PP
Ensembles can be nested.  For example, the \fBinfo\fR command has
an ensemble \fBinfo namespace\fR within it.  This ensemble has parts
like \fBinfo namespace all\fR and \fBinfo namespace children\fR.
.PP
With ensembles, composite commands can be created and extended
in an automatic way.  Any package can find an existing ensemble
and add new parts to it.  So extension writers can add their
own parts, for example, to the \fBinfo\fR command.
.PP
The ensemble facility manages all of the part names and keeps
track of unique abbreviations.  Normally, you can abbreviate
\fBinfo complete\fR to \fBinfo comp\fR.  But if an extension adds the
part \fBinfo complexity\fR, the minimum abbreviation for \fBinfo complete\fR
becomes \fBinfo complet\fR.
.PP
The ensemble facility not only automates the construction of
composite commands, but it automates the error handling as well.
If you invoke an ensemble command without specifying a part name,
you get an automatically generated error message that summarizes
the usage information.  For example, when the \fBinfo\fR command
is invoked without any arguments, it produces the following error
message:
.CS
wrong # args: should be one of...
  info args procname
  info body procname
  info cmdcount
  info commands ?pattern?
  info complete command
  info context
  info default procname arg varname
  info exists varName
  info globals ?pattern?
  info level ?number?
  info library
  info locals ?pattern?
  info namespace option ?arg arg ...?
  info patchlevel
  info procs ?pattern?
  info protection ?-command? ?-variable? name
  info script
  info tclversion
  info vars ?pattern?
  info which ?-command? ?-variable? ?-namespace? name\fR
.CE
You can also customize the way an ensemble responds to errors.
When an ensemble encounters an unspecified or ambiguous part
name, it looks for a part called \fB@error\fR.  If it exists,
then it is used to handle the error.  This part will receive all
of the arguments on the command line starting with the offending
part name.  It can find another way of resolving the command,
or generate its own error message.

.SH EXAMPLE
We could use an ensemble to clean up the syntax of the various
"wait" commands in Tcl/Tk.  Instead of using a series of
strange commands like this:
.CS
vwait x
tkwait visibility .top
tkwait window .
.CE
we could use commands with a uniform syntax, like this:
.CS
wait variable x
wait visibility .top
wait window .
.CE
The Tcl package could define the following ensemble:
.CS
ensemble wait part variable {name} {
    uplevel vwait $name
}
.CE
The Tk package could add some options to this ensemble, with a
command like this:
.CS
ensemble wait {
    part visibility {name} {
        tkwait visibility $name
    }
    part window {name} {
        tkwait window $name
    }
}
.CE
Other extensions could add their own parts to the \fBwait\fR command
too.

.SH KEYWORDS
ensemble, part, info
