proc dbdump {database {args ""}} {
    set nws 0
    set search [lsearch $args -neowebscript]
    if {$search > -1} {
	set args [lreplace $args $search $search]
	set nws 1
    }

    set search [lsearch $args -nws]
    if {$search > -1} {
	set args [lreplace $args $search $search]
	set nws 1
    }

    # Setting some default variables.
    set data(pattern) *
    set data(format) parray
    set data(seperator) ,
    set data(datafile) remove

    if ![lempty $args] {
        import_keyvalue_pairs data $args
    }

    if {[info exists data(file)] && $data(datafile) == "remove"} {
        filerm data $data(file)
    }

    if [info exists data(file)] {
        set ofp [access_data_file $data(file)]
	seek $ofp 0 end
    }

    foreach key [dbkeys $database $data(pattern)] {
        dbfetch $database $key array

        if [info exists data(file)] {
	    if $nws {
		if ![info exists sent_header] {
                    set sent_header 1
                    puts -nonewline $ofp "#THIS FILE IS FORMATED FOR "
		    puts -nonewline $ofp "NEOWEBSCRIPT DBIMPORT.  DO NOT "
		    puts $ofp REMOVE THIS COMMENT"
                }
                set line [list $key [array get array]]
                puts $ofp $line
                unset line
            } else {
                foreach elem [array names array] {
                    append line "$array($elem)$data(seperator)"
                }
		puts $ofp "[crange $line 0 end-1]"    
		if [info exists line] {unset line}
		if [array exists array] {unset array}
            }
        }

	if [info exists sent_headers] {unset sent_headers}

	switch $data(format) {
	    parray {
                html "\[$key\]"
                parray array
                if [array exists array] {unset array}
	    }

	    list {
                html "\[$key\]"
                foreach elem [array names array] {
                    html "$elem=$array($elem)$data(seperator) "
                }
                if [array exists array] {unset array}
	    }

	    delineated {
		if $nws {
                    if ![info exists num2] {
                        set num2 1
                        html "#THIS FILE IS FORMATED FOR NEOWEBSCRIPT "
			html "DBIMPORT.  DO NOT REMOVE THIS COMMENT.\n"
                    }
                    set line [list $key [array get array]]
                    html $line\n
                    if [info exists line] {unset line}
                    if [array exists array] {unset array}
                } else {
                    foreach elem [array names array] {
                        append line "$array($elem)$data(seperator)"
                    }
                    html "[crange $line 0 end-1]\n"
                    if [info exists line] {unset line}
                    if [array exists array] {unset array}
                }
            }

        }

    }

    if [info exists ofp] {
	catch {close $ofp}
    }
}

proc dbimport {file database args} {
    set num 0
    set nws 0

    set search [lsearch $args -datafile]
    if {$search > -1} {
	set args [lreplace $args $search $search]
	set ifp [access_data_file $file]
    } else {
        set ifp [open [pwd]/$file r]
    }

    # Set some default variables.
    set data(seperator) ,
    set data(key) numbers
    set data(db) remove

    if ![lempty $args] {
	import_keyvalue_pairs data $args
    }

    gets $ifp tmpline

    if [string match "*NEO*SCRIPT DBIMPORT*" $tmpline] {
	set nws 1
    } else {
	seek $ifp 0
    }

    if {[string match "*NEO*SCRIPT DBIMPORT*" $tmpline] \
	|| [info exists data(fields)]} {
        seek $ifp 0
        set haveFields 1
    }

    if {!$nws && ![info exists data(fields)]} {
	return -code error "-fields not set"
    }

    if {$data(db) == "remove"} {filerm db $database}

    if $nws {
	while {[lgets $ifp line] != -1} {
	    if [lempty $line] continue
	    set key [lindex $line 0]
	    array set store [lindex $line 1]
	    dbstore $database $key store
	}
	return
    }

    while {[gets $ifp line] != -1} {
	if [lempty $line] continue
	set fields $data(fields)
	incr num
	for {set i 0} {$i < [llength $fields]} {incr i} {
	    if {[lindex $fields $i] != "key"} {
		set array([lindex $fields $i]) [lindex $line $i]
		if {[lindex $fields $i] == $data(key)} {
		    set key [lindex $line $i]
		}
	    } else {
		set id [lindex $line $i]
	    }
	}

	if {[info exists data(key)] && $data(key) != "numbers"} {
	    set id $key
	} elseif {[info exists id]} {
	} else {
	    set id $n
	}

	dbstore $database $id array
    }    
}
