proc visitor_info {args} {
    global webenv

    set data(function) record
    set data(show) "grandTotal,dailyTotals,hosts,referers"
    set data(file) {}

    if {[cindex $args 0] == "-"} {
	set counterName [lindex $args end]
	set imports [lrange $args 0 [expr [llength $args] - 2]]
	if [catch {import_keyvalue_pairs data $imports}] {
	    return -code error "Incorrect keyvalue pairs."
	}
    } else {
	set counterName [lindex $args 0]
    }

    if {$counterName == {}} {
	return -code error "No counter name specified."
    }

    switch $data(function) {
	record {
	    incr_visitor_info_hits $counterName
	}

	report {
	    report_visitor_info_hits $counterName $data(show)
	}

	archive {
	    archive_visitor_info_hits $counterName $data(file)
	}

	default {
	    incr_visitor_info_hits $counterName
	}
    }
}

proc incr_visitor_info_hits {counterName} {
    set date [clock format [clock seconds] -format %D]
    set hostName [string tolower [remote_hostname]]
    if [info exists webenv(HTTP_REFERER)] {
	set referer [crange $webenv(HTTP_REFERER) 7 end]
	set split [split $referer ?]
	set referer [lindex $split 0]
    } else {
	set referer {No Referring URL}
    }

    dbfetch VisitorInfo totals totals
    dbfetch VisitorInfo $counterName-refs-$referer refs
    dbfetch VisitorInfo $counterName-hosts-$hostName hosts

    incr0 totals($counterName-grandTotal)
    incr0 totals($counterName-dailyTotal-$date)
    incr0 refs(hits)
    incr0 hosts(hits)

    dbstore VisitorInfo totals totals
    dbstore VisitorInfo $counterName-refs-$referer refs
    dbstore VisitorInfo $counterName-hosts-$hostName hosts
}

proc report_visitor_info_hits {counterName show} {
    if {[dbkeys VisitorInfo $counterName*] == {}} {
	return -code error "$counterName: counter does not exist."
    }

    if ![dbexists VisitorInfo] {
	return -code error "You have no visitor_info counters."
    }

    foreach report [split $show ,] {
	set report [string tolower $report]
	if [catch {report_$report $counterName}] {
	    return -code error "I don't know how to report $report"
	}
	html <hr>
    }

}

proc archive_visitor_info_hits {counterName file} {
    if [lempty $file] {
	set file VisitorInfo_$counterName
    }

    set fp [access_data_file $file]
}

proc report_grandtotal {counterName} {
    dbfetch VisitorInfo totals totals
    html <p>
    html <table>
    html <tr>
    html "<td><center><h3>Grand Total:</td>"
    html "<td>$totals($counterName-grandTotal)</td>"
    html </tr>
    html </table>
}

proc report_dailytotals {counterName} {
    dbfetch VisitorInfo totals totals
    html <p>
    html "Daily Totals:" h3
    html <hr>
    html <table>
    html <tr>
    html "<td><center>Date</td>"
    html "<td>Total Hits</td>"
    html </tr>
    foreach day [array names totals $counterName-dailyTotal-*] {
	html <tr>
	html "<td>[lindex [split $day -] 2]</td>"
	html "<td><center>$totals($day)</td>"
	html </tr>
    }
    html </table>
}

proc report_hosts {counterName} {
    html <p>
    html "Remote Host Count:" h3
    html <hr>
    html <table>
    html <tr>
    html "<td><center>Hostname</td>"
    html "<td>Total Hits</td>"
    html </tr>
    foreach key [dbkeys VisitorInfo $counterName-hosts-*] {
	dbfetch VisitorInfo $key count
	set host [lindex [split $key -] end]
	html <tr>
	html "<td>$host</td>"
	html "<td><center>$count(hits)</td>"
	html </tr>
    }
    html </table>
}

proc report_referers {counterName} {
    html <p>
    html "Document Referer Count:" h3
    html <hr>
    html <table>
    html <tr>
    html "<td><center>Referer</td>"
    html "<td>Total Hits</td>"
    html </tr>
    foreach key [dbkeys VisitorInfo $counterName-refs-*] {
	dbfetch VisitorInfo $key count
	set referer [lindex [split $key -] end]
	html <tr>
	html "<td>$referer</td>"
	html "<td><center>$count(hits)</td>"
	html </tr>
    }
    html </table>
}
