#
# Tcl program to feed manpages through rosetta, create indexes, and the
# like.
#
# $Id$
#

set docDirs "tcl7.3/doc tk3.6/doc itcl-1.5/man tclX7.3b/man tdpm3.2/doc/man1 tdpm3.2/doc/man3 tdpm3.2/doc/mann"

proc convert {file} {
    global cwd

    set command "nroff -man $file | rman -f html -r '%s.%s.html' >$cwd/html/manpages/$file.html"
    echo $command
    system $command
}

proc add_index {dir file} {
    global cwd openIndexFiles

    if ![info exists openIndexFiles($dir)] {
	set openIndexFiles($dir) [open $cwd/html/Index-[lindex [split $dir "/"] 0].html w]
	puts $openIndexFiles($dir) "<title>Index of $dir</title>"
	puts $openIndexFiles($dir) "<h1>Index of $dir</h1>\n"
	puts $openIndexFiles($dir) "<ul>"
    }
    puts $openIndexFiles($dir) "<li><a href=$file.html>$file</a>"
}

proc close_indexes {} {
    global openIndexFiles

    foreach index [array names $openIndexFiles] {
	puts $openIndexFiles($index) "</ul>"
	close $openIndexFiles($index) 
    }
}

proc doit {} {
    global docDirs cwd

    set cwd [pwd]

    cd expect-5.13
    foreach file [glob *.man] {
	convert $file
	add_index expect-5.13 $file
    }

    foreach docDir $docDirs {
	cd $cwd/$docDir
	foreach file [glob *] {
	    if [file isdirectory $file] continue
	    if {$file == "man.macros" || $file == "Makefile" || $file == "Makefile.in" || $file == "README"} continue

	    convert $file
	    add_index $docDir $file
	}
    }
    close_indexes
}

if !$tcl_interactive doit
