
#
#
#
#
#
# expect.man
#

set docDirs "tcl7.3/doc tk3.6/doc tdpm3.2/doc itcl-1.5/man tclX7.3b/man"

proc process_dir {} {
    foreach docDir $docDirs {

	cd $cwd/$docDir

	foreach file [glob *] {
	    if [file isdirectory $file] continue
	    if {$file == "man.macros" || $file == "Makefile" || $file == "Makefile.in" || $file == "README"} continue

	    set section [lindex [split $file "/"] 0]

	    if {![info exists sawSection($section)]} {
		set sawSection($section) ""
		puts $mainIndexFP $section
	    }

	    set command "nroff -man $file | rman -f html -r '%s.%s.html' >$cwd/html/$file.html"
	    echo $command
	    system $command
	}
    }
}

proc doit {} {
    global docDirs

    set cwd [pwd]

    foreach oneLinerFile [glob tclX7.3b/*help/*.brf] {
	echo $oneLinerFile
    }

}

if !$tcl_interactive doit
