#@package: spawn_child spawn_child

#
# Copyright (C) 1992-1994 NeoSoft.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies.  NeoSoft makes no 
# representations about the suitability of this software for any purpose.
# It is provided "as is" without express or implied warranty.

#
# spawn_child - fork a tcl subprocess, redirecting standard input,
# output and error to pipes.
#
# Three variable names are specified.
# Within those variables spawn_child writes the filehandles of pipes that
# correspond to standard input, standard output and standard error of
# the subprocess.
#

proc spawn_child {command stdinPipeVarName stdoutPipeVarName stderrPipeVarName} {

    upvar $stdinPipeVarName stdinPipe \
	  $stdoutPipeVarName stdoutPipe \
	  $stderrPipeVarName stderrPipe

    pipe childStdinPipe stdinPipe
    pipe stdoutPipe childStdoutPipe
    pipe stderrPipe childStderrPipe

    if {[set childPid [fork]] == 0} {

        dup $childStdinPipe stdin
        close $childStdinPipe

        dup $childStdoutPipe stdout
        close $childStdoutPipe

        dup $childStderrPipe stderr
        close $childStderrPipe

        eval "execl $command"
    }
    return $childPid
}

