
set encryptedFileString "Solid Systems CD-ROM Jukebox"


proc encrypt_file {sourceFile destFile} {
    global encryptedFileString fileKeys

    set tailName [file tail $sourceFile]

    if {![info exists fileKeys($tailName)]} {
	echo "copying plaintext $sourceFile to $destFile -- no key for file in fileKeys"
	write_file $destFile [read_file $sourceFile]
	return
    }

    echo "encrypting $sourceFile to $destFile"
    write_file $destFile \
	[neo_encrypt [read_file $sourceFile] $fileKeys($tailName) $encryptedFileString $tailName]
}

proc encrypt_directory {sourceDir destDir} {
    set files [glob -nocomplain $sourceDir/*.tcl $sourceDir/*.tlib]
    if {$files == ""} {
	echo "no .tcl or .tlib files in $sourceDir to encrypt"
    }

    foreach file $files {
	encrypt_file $sourceDir/$file $destDir/$file
    }
}

proc usage {} {
    puts stderr "usage: encryptdir sourceDir destDir"
    exit 1
}

proc doit {argv} {
    if {[llength $argv] != 2} usage

    if ![file exists encryptconfig.tcl] {
	puts stderr "cannot find encryptconfig.tcl, encryption aborted"
	exit 4
    }
    uplevel #0 source encryptconfig.tcl

    lassign $argv sourceDir destDir

    if ![file isdirectory $sourceDir] {
	puts stderr "source dir '$sourceDir' doesn't exit"
	exit 2
    }

    if ![file isdirectory $destDir] {
	puts stderr "dest dir '$destDir' doesn't exit"
	exit 3
    }

    encrypt_directory $sourceDir $destDir
}

if !$tcl_interactive {doit $argv}
