#@package: neocanvas create_scrollable_canvas

#
# $Id: neocanvas.tcl,v 2.0 1994/12/23 20:04:30 karl Exp $
#

proc create_scrollable_canvas {w} {

    frame $w
    canvas $w.canvas -yscroll "$w.yscroll set" -xscroll "$w.xscroll set" \
        -width 15c -height 5c -relief sunken

    scrollbar $w.yscroll -relief sunken \
        -command "$w.canvas yview"

    scrollbar $w.xscroll -relief sunken -orient horiz \
        -command "$w.canvas xview"

    pack $w.xscroll -side bottom -fill x
    pack $w.yscroll -side right -fill y
    pack $w.canvas -in $w -expand yes -fill both
    pack $w -side top -expand yes -fill both
    return $w
}

