#@package: textclass TextClass

#
# incr tcl class for manipulating text widgets
#

itcl_class TextClass {

    constructor {config} {
	add_bindings
    }

    destructor {}

    method adjust_insert {position} {
	$textWidget mark set insert $position
	$textWidget yview -pickplace insert
    }

    method up {{lines 1}} {
	adjust_insert "insert - $lines line"
    }

    method down {{lines 1}} {
	adjust_insert "insert + $lines line"
    }

    method left {{chars 1}} {
	adjust_insert "insert - $chars chars"
    }

    method right {{chars 1}} {
	adjust_insert "insert + $chars chars"
    }

    method home {} {
	adjust_insert 1.0
    }

    method end {} {adjust_insert end}

    method add_bindings {} {
	bind $textWidget <Up> "$this up"
	bind $textWidget <Down> "$this down"
	bind $textWidget <Left> "$this left"
	bind $textWidget <Right> "$this right"
	bind $textWidget <Home> "$this home"
	bind $textWidget <End> "$this end"
    }

    public textWidget
}

