#@package: PasswordBox PasswordBox

#
# This file defines a PasswordBox class which will create a password
# widget that types asterisks into the entry widget as the user types keys,
# rather than the keys the user typed.
#
# $Id: tkpassword.tcl,v 2.0 1994/12/23 20:04:38 karl Exp $
#

itcl_class PasswordBox {

    method insert_char {char key} {
	if {$char == ""} return

	append password $char

	$widgetName.password insert end "*"
    }

    method delete_char {} {

        if {$password == ""} return
	set length [clength $password]
	if {$length == 0} return
	if {$length == 1} {
	    set password ""
	    $widgetName.password delete 0 end
	    return
	}
	set password [crange $password 0 {[clength $password] - 2}]
	$widgetName.password delete 0
    }

    method run {config} {
	set password ""
	catch {destroy $widgetName}
	toplevel $widgetName
	wm minsize $widgetName 1 1
	wm title $widgetName "Password Entry"

	label $widgetName.label -text "Enter Password:"
	pack $widgetName.label

	entry $widgetName.password -relief raised
	pack $widgetName.password

	focus $widgetName.password

	bind $widgetName.password <Key> "$this insert_char %A %K"
	bind $widgetName.password <BackSpace> "$this delete_char"
	bind $widgetName.password <Delete> "$this delete_char"
	bind $widgetName.password <Return> "destroy $widgetName"

	center_window $widgetName

	tkwait window $widgetName
	return $password
    }

    method configure {config} {
    }

    public password ""
    public widgetName ".password"
}

