
#@package: getargs getargs

# $Log: getargs.tcl,v $
# Revision 2.0  1994/12/23  20:04:54  karl
# Bringing everything to rev 2.0.
#
# Revision 1.1  1994/12/23  17:58:49  karl
# Checkin in neosoft tcl tool library.
#
# Revision 1.1  1993/12/06  01:13:16  karl
# Initial version.
#

#
# parses an arglist of key-value pairs where the key starts with a
# dash and the value must always be present.
#
# we want to use it in this manner 
#
# dialog_box -bitmap @/bitmap -text "hi there" -suppress 1
#
# in dialog_box,
#
# proc dialog_box {blah blah blah args} {
#     getargs $args parms
# }
#
# and have the parms array set as follows:
#
# bitmap=@/bitmap
# text="hi there"
# suppress="1"
#
#

proc getargs {arrayName argList} {
    upvar $arrayName array

    set length [llength $argList]
    if {$length % 2 != 0} {
        error "list of key-value pairs is missing a value"
    }
    for {set i 0} {$i < $length} {incr i 2} {
        set key [lindex $argList $i]
        if {[cindex $key 0] != "-"} {
            error "key '$key' of key-value pairs doesn't start with '-'"
        }
        set array([crange $key 1 end]) [lindex $argList [expr $i + 1]]
    }
}
