
#@package: rfc822 read_rfc822_group read_rfc822 write_rfc822_group write_rfc822 parse_rfc822_mail_address

# $Log: rfc822.tcl,v $
# Revision 2.0  1994/12/23  20:04:58  karl
# Bringing everything to rev 2.0.
#
# Revision 1.1  1994/12/23  17:58:52  karl
# Checkin in neosoft tcl tool library.
#
# Revision 1.3  1994/11/17  01:44:31  karl
# RFC822 stuff should now handle multiline elements.  Also now has a new
# routine, parse_rfc822_mail_address which attempts to parse various mail
# address formats into an address and username.
#
# prompts are just some lame little procs to do prompts and inputs.
#
# Revision 1.2  1993/12/06  00:53:38  karl
# Added CVS Log lines.  Minor doc cleanup.
#

#
# we really need to rewrite this in C and be truly RFC-822 compliant,
# it's a pig.
#
# RFC noncompliance issues: Line order isn't maintained, multiple
# lines with the same key aren't supported.
# There may be stuff in there about quoting, too.
#

#
# read_rfc822_group
#
# given a filehandle and an array name, read the file, pulling key-value
# pairs and putting them into the named array, returning when an empty
# line or EOF is found
#
#
proc read_rfc822_group {fp arrayVarName} {
    upvar $arrayVarName rfcArray
    set success 0
    
    while {[gets $fp line] >= 0} {
        if {[string trim $line] == ""} break

	set firstchar [cindex $line 0]
	if {$firstchar == " " || $firstchar == "\t"} {
	    lappend rfcArray($key) $line
	    continue
	}
        set colon [string first ":" $line]
        if {$colon < 2} {
            error "malformed rfc-822 line '$line'"
        }
        set success 1
        set key [string trim [string range $line 0 [expr $colon-1]]]
        set value [string trim [string range $line [expr $colon+1] end]]
        set rfcArray($key) $value
    }
    return $success
}

#
# read_rfc822
#
# load in a file containing one rfc822 group
#
proc read_rfc822 {fileName arrayVarName} {
    upvar $arrayVarName rfcArray
    
    set fp [open $fileName]
    read_rfc822_group $fp rfcArray
    close $fp
}

#
# write_rfc822_group
#
# given a filehandle and an array name, write the file, pulling key-value
# pairs from the named array, returning when finished.
#
#
proc write_rfc822_group {fp arrayVarName} {
    upvar $arrayVarName rfcArray
    
    foreach name [array names rfcArray] {
        puts $fp "$name: $rfcArray($name)"
    }
    puts $fp ""
}

#
# write_rfc822
#
# write out a file containing one rfc822 group
#
proc write_rfc822 {fileName arrayVarName} {
    upvar $arrayVarName rfcArray
    
    set fp [open $fileName w]
    write_rfc822_group $fp rfcArray
    close $fp
}

#
# parse_rfc822_mail_address
#
# take the body of an address line and convert it into a name and address
#
proc parse_rfc822_mail_address {line emailAddressVar fullNameVar} {
    upvar $emailAddressVar emailAddress
    upvar $fullNameVar fullName
 
    # in the form "Ellyn Jones <ellyn@NeoSoft.com>"?
    if {[regexp {(.*) <(.*)>} $line dummy fullName emailAddress]} {
        set emailAddress [string tolower $emailAddress]
        return
    }   
    
    # in the form "ellyn@NeoSoft.com (Ellyn Jones)"?
    if {[regexp {(.*) \((.*)\)} $line dummy emailAddress fullName]} {
        set emailAddress [string tolower $emailAddress]
        return
    }
 
    # hmm, take whatever's there as the reply address 
    set emailAddress [string tolower $line]
    set fullName $emailAddress
}

