#@package: rfc931 rfc931

#
# Perform an rfc931 authentication request on the socket bound to the
# specified filehandle.  Returns username and hostname if found,
# username and ip if no hostname is found, or an empty string if
# the remote site isn't running an rfc931 authentication server.
#
# $Id: rfc931.tcl,v 2.0 1994/12/23 20:04:59 karl Exp $
#

proc rfc931 {fp resultVar} {
    upvar $resultVar result

    lassign [fstat $fp remotehost] ip name localPort remotePort

    if {[catch {lassign [server_open $ip ident] readIdent writeIdent} result] == 1} {
	global errorCode errorInfo
	if {[lindex $errorCode 1] == "ECONNREFUSED"} {return 0}
	error $result $errorInfo $errorCode
    }
    if {$name == ""} {set name $ip}

    puts $writeIdent "$remotePort,$localPort\r"
    #puts $writeIdent "$localPort,$remotePort\r"
    close $writeIdent

    if {[gets $readIdent authLine] < 0} {
	close $readIdent
	set result "read failed"
	return 0
    }

    set result $authLine
    if {[scan $authLine {%u , %u : USERID :%*[^:]:%s} remote local user] != 3} {
	return 0
    }

    if {$remote != $remotePort || $local != $localPort} {
	close $readIdent
	set result "ports didn't match"
	return 0
    }

    if {[cindex $user end] == "\r"} {
	set user [crange $user 0 end-1]
    }
    set result $user@$name
    return 1
}
