#@package: rcmp-client-object RcmpClient

#
# Remote Computer Management Protocol (RCMP)
#
# Basic object-tcl client class for building RCMP clients.
#
# karl lehenbauer 10/94
#
# $Id: rcmpc.tcl,v 2.0 1994/12/23 20:05:13 karl Exp $
#

itcl_class RcmpClient {

    constructor {config} {
    }

    destructor {
    }

    method configure {config} {
    }

    method disconnect {} {
	close $fromFP
	close $toFP
	set connected 0
    }

    method connect {{connectHost ""}} {
	if $connected disconnect

        if {$connectHost != ""} {set host $connectHost}

	lassign [server_open $host $rcmpPort] fromFP toFP

	if {[send "" onlineMessage] != 2} {
	    error "connect failed: $onlineMessage"
	}
	set connected 1
    }

    method disk {} {
	if {[send disk response data] != 2} {
	    error "disk request failed"
	}
	echo $data
	echo $response
    }

    method login {user password} {
	if {[send "USER $user"]  != 3} {
	    error "error sending user"
	}

	if {[send "PASS $password"] != 2} {
	    error "error sending password"
	}
    }

    method send {message {responseVar ""} {multilineVar ""}} {
	if {$multilineVar != ""} {
	    upvar $multilineVar multilineResponse
	}

	if {$responseVar != ""} {
	    upvar $responseVar response
	}

	set multilineResponse ""
	set inMultiline 0

	if {$message != ""} {
	    puts $toFP $message
	    flush $toFP
	}

        while 1 {
	    if {[gets $fromFP line] < 0} {
		error "EOF from RCMP server"
	    }
	    set firstChar [cindex $line 0]
	    if {!$inMultiline && $firstChar != 1} {
		set response $line
		return $firstChar
	    }
	    if !$inMultiline {
		if {$firstChar != 1} {error "protocol failure reading server"}
		if {[cindex $line 3] == "-"} {
		    set inMultiline 1
		} else {
		    set multilineResponse $line
		}
	    } else {
		# really should make sure we have three entire digits
		if {$firstChar == 1 && [cindex $line 3] == " "} {
		    set inMultiline 0
		} else {
		    lappend multilineResponse $line
		}
	    }
	}
    }

    protected fromFP
    protected toFP

    protected connected 0
    protected state "new"

    public host
    public rcmpPort 222
}

