
#
# diffcdir will compare two directory hierarchies and produce
# context diffs of what's change from one to the other
#
# $Id: diffcdir.tcl,v 2.0 1994/12/23 20:05:18 karl Exp $
#
#

proc diffcdir {old_dir new_dir} {
    set cwd [pwd]

    cd $old_dir
    set oldList [eval exec find [glob *] -print]

    cd $cwd
    cd $new_dir
    set newList [eval exec find [glob *] -print]
    cd $cwd

    set list [intersect3 $oldList $newList]
    set oldOnly [lindex $list 0]
    echo "#files in old but not new: $oldOnly"

    foreach newOnly [lindex $list 2] {
        system "diff -c /dev/null $new_dir/$newOnly"
    }
    foreach fileInBoth [lindex $list 1] {
        system "diff -c $old_dir/$fileInBoth $new_dir/$fileInBoth"
    }
}

proc main {argv} {
    if {[llength $argv] != 2} {
        puts stderr "usage: diffcdir old_dir new_dir"
        exit 1
    }

    diffcdir [lindex $argv 0] [lindex $argv 1]
}

if !$tcl_interactive {main $argv}
