#
# Embed Tcl in text -- Text formatting language based on Tcl
#
# Copyright (C) 1994 NeoSoft, All Rights Reserved.
#
# $Id: expand.tcl,v 2.0 1994/12/23 20:05:20 karl Exp $
#

proc expand_embedded_tcl {string procName} {
    while 1 {
        if ![regexp -indices {\\\$([^ ]*)|\\'([^ ]*)|\\`(.*)\\`} \
            $string matchedItem expandVar expandWord expandPhrase] {
                $procName $string
                return
	}
	$procName [crange $string 0 [lindex $matchedItem 0]-1]
	if {$expandVar != "-1 -1"} {
	    $procName [uplevel #0 "set [crange $string [lindex $expandVar 0] [lindex $expandVar 1]]"]
	}
	if {$expandWord != "-1 -1"} {
	    $procName [[crange $string [lindex $expandWord 0] [lindex $expandWord 1]]]
	}
	if {$expandPhrase != "-1 -1"} {
	    $procName [eval [crange $string [lindex $expandPhrase 0] [lindex $expandPhrase 1]]]
	}
	set string [crange $string [lindex $matchedItem 1]+1 end]
    }
}

proc tryit {x} {
    echo "trying '$x'"
    expand_embedded_tcl $x echo
    echo
}

set fish halibut

proc foo {args} {
    return "$args"
}

tryit {I ordered \$fish dammit!}
tryit {I ordered foo, foobar.}
tryit {I ordered \'foo foobar. you know?}
tryit {I ordered \`foo fram\` you know?}

