#
#
#
#
# $Id: mailwalker.tcl,v 2.0 1994/12/23 20:05:23 karl Exp $
#
#

proc grind_mail {} {
    global MAIL mailMessages mailInfo

    set mailMessages 0

    set mainContext [scancontext create]
    scanmatch $mainContext "^From " {
        global mailMessages; incr mailMessages
	keylset mailInfo($mailMessages)  offset $matchInfo(offset)
	scanfile $messageContext $matchInfo(handle)
    }

    set messageContext [scancontext create]
    scanmatch $messageContext "^Subject: " {
	keylset mailInfo($mailMessages) subject [crange $matchInfo(line) 9 end]
    }
    scanmatch $messageContext "^From: " {
	keylset mailInfo($mailMessages) from [crange $matchInfo(line) 6 end]
    }
    scanmatch $messageContext "^$" {
	break
    }

    set fp [open $MAIL]
    scanfile $mainContext $fp
    close $fp
    scancontext delete $messageContext
    scancontext delete $mainContext
}

proc crack_from_line {fromLine userVarName hostVarName userRealLifeVarName} {
    upvar $userVarName user
    upvar $hostVarName host
    upvar $userRealLifeVarName userName

    set idx [string first "(" $fromLine]
    if {$idx != -1} {
        set endidx [string last ")" $fromLine]
        set userName [crange $fromLine $idx+1 $endidx-1]
        set hostPair [crange $fromLine 0 $idx-2]
    } else {
        set idx [string first "<" $fromLine]
        set endidx [string last ">" $fromLine]
	if {$idx != -1 && $endidx != -1} {
            set hostPair [crange $fromLine $idx+1 $endidx-1]
            set userName [crange $fromLine 0 $idx-2]
	} else {
	    set hostPair $fromLine
	    set userName $fromLine
	}
    }
    set hostPair [split $hostPair "@"]
    set user [lindex $hostPair 0]
    set host [lindex $hostPair 1]
}

proc dump_mail {} {
    global mailMessages mailInfo

    for {set message 1} {$message <= $mailMessages} {incr message} {
        set mailData $mailInfo($message)
	keylget mailData offset offset
	if {[keylget mailData subject subject] == 0} {
	    set subject "<no subject>"
        }
	keylget mailData from from

	echo "message $message, from '$from', subject '$subject'"
        crack_from_line $from user host userName
        echo "    user $user host $host userName $userName"
    }
}

proc doit {} {
    global env MAIL

    #set MAIL $env(MAIL)
    set MAIL ~karl/tclsrc/pop-puller/mailboxes/karl

    grind_mail
    dump_mail
}

if !$tcl_interactive doit

