#!/usr/local/bin/tcl

proc static {args} {
    set procName [lindex [info level -1] 0]
    foreach varName $args {
        uplevel 1 "upvar #0 $procName:$varName $varName"
    }
}

proc testproc {} {
    static blockhead

    if ![info exists blockhead] {
        set blockhead 0
    } else {
        incr blockhead
    }
    echo "blockhead static var is $blockhead"
}

testproc
testproc
testproc

echo [info globals]

static dork
