'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /usr/cvs/NEOSOFT/inet_workstation/tcl7.3/tcl7.3/doc/error.n,v 2.0 1994/12/23 20:11:34 karl Exp $ SPRITE (Berkeley)
'\" 
.so man.macros
.HS error tcl
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
error \- Generate an error
.SH SYNOPSIS
\fBerror \fImessage\fR ?\fIinfo\fR? ?\fIcode\fR?
.BE

.SH DESCRIPTION
.PP
Returns a TCL_ERROR code, which causes command interpretation to be
unwound.  \fIMessage\fR is a string that is returned to the application
to indicate what went wrong.
.PP
If the \fIinfo\fR argument is provided and is non-empty,
it is used to initialize the global variable \fBerrorInfo\fR.
\fBerrorInfo\fR is used to accumulate a stack trace of what
was in progress when an error occurred; as nested commands unwind,
the Tcl interpreter adds information to \fBerrorInfo\fR.  If the
\fIinfo\fR argument is present, it is used to initialize
\fBerrorInfo\fR and the first increment of unwind information
will not be added by the Tcl interpreter.  In other
words, the command containing the \fBerror\fR command will not appear
in \fBerrorInfo\fR; in its place will be \fIinfo\fR.
This feature is most useful in conjunction with the \fBcatch\fR command:
if a caught error cannot be handled successfully, \fIinfo\fR can be used
to return a stack trace reflecting the original point of occurrence
of the error:
.DS
\fBcatch {...} errMsg
set savedInfo $errorInfo
\&...
error $errMsg $savedInfo\fR
.DE
.PP
If the \fIcode\fR argument is present, then its value is stored
in the \fBerrorCode\fR global variable.  This variable is intended
to hold a machine-readable description of the error in cases where
such information is available; see the section BUILT-IN VARIABLES
below for information on the proper format for the variable.
If the \fIcode\fR argument is not
present, then \fBerrorCode\fR is automatically reset to
``NONE'' by the Tcl interpreter as part of processing the
error generated by the command.

.SH KEYWORDS
error, errorCode, errorInfo
