'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /usr/cvs/NEOSOFT/inet_workstation/tcl7.3/tcl7.3/doc/glob.n,v 2.0 1994/12/23 20:11:49 karl Exp $ SPRITE (Berkeley)
'\" 
.so man.macros
.HS glob tcl 7.0
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
glob \- Return names of files that match patterns
.SH SYNOPSIS
\fBglob \fR?\fIswitches\fR? \fIpattern \fR?\fIpattern ...\fR?
.BE

.SH DESCRIPTION
.PP
This command performs file name ``globbing'' in a fashion similar to
the csh shell.  It returns a list of the files whose names match any
of the \fIpattern\fR arguments.
.LP
If the initial arguments to \fBglob\fR start with \fB\-\fR then
.VS
they are treated as switches.  The following switches are
currently supported:
.TP 15
\fB\-nocomplain\fR
Allows an empty list to be returned without error;  without this
switch an error is returned if the result list would be empty.
.TP 15
\fB\-\|\-\fR
Marks the end of switches.  The argument following this one will
be treated as a \fIpattern\fR even if it starts with a \fB\-.
.VE
.PP
The \fIpattern\fR arguments may contain any of the following
special characters:
.TP 10
\fB?\fR
Matches any single character.
.TP 10
\fB*\fR
Matches any sequence of zero or more characters.
.TP 10
\fB[\fIchars\fB]\fR
Matches any single character in \fIchars\fR.  If \fIchars\fR
contains a sequence of the form \fIa\fB\-\fIb\fR then any
character between \fIa\fR and \fIb\fR (inclusive) will match.
.TP 10
\fB\e\fIx\fR
Matches the character \fIx\fR.
.TP 10
\fB{\fIa\fB,\fIb\fB,\fI...\fR}
Matches any of the strings \fIa\fR, \fIb\fR, etc.
.LP
As with csh, a  ``.'' at the beginning of a file's name or just
after a ``/'' must be matched explicitly or with a {} construct.
In addition, all ``/'' characters must be matched explicitly.
.LP
If the first character in a \fIpattern\fR is ``~'' then it refers
to the home directory for the user whose name follows the ``~''.
If the ``~'' is followed immediately by ``/'' then the value of
the HOME environment variable is used.
.LP
The \fBglob\fR command differs from csh globbing in two ways.
First, it does not sort its result list (use the \fBlsort\fR
command if you want the list sorted).
.VS
Second, \fBglob\fR only returns the names of files that actually
exist;  in csh no check for existence is made unless a pattern
contains a ?, *, or [] construct.
.VE

.SH KEYWORDS
exist, file, glob, pattern
