'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /usr/cvs/NEOSOFT/inet_workstation/tcl7.3/tcl7.3/doc/regsub.n,v 2.0 1994/12/23 20:12:25 karl Exp $ SPRITE (Berkeley)
'\" 
.so man.macros
.HS regsub tcl
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
regsub \- Perform substitutions based on regular expression pattern matching
.SH SYNOPSIS
\fBregsub \fR?\fIswitches\fR? \fIexp string subSpec varName\fR
.BE

.SH DESCRIPTION
.PP
This command matches the regular expression \fIexp\fR against
\fIstring\fR,
.VS
and it copies \fIstring\fR to the variable whose name is
given by \fIvarName\fR.
The command returns 1 if there is a match and 0 if there isn't.
If there is a match, then while copying \fIstring\fR to \fIvarName\fR
the portion of \fIstring\fR that
.VE
matched \fIexp\fR is replaced with \fIsubSpec\fR.
If \fIsubSpec\fR contains a ``&'' or ``\e0'', then it is replaced
in the substitution with the portion of \fIstring\fR that
matched \fIexp\fR.
If \fIsubSpec\fR contains a ``\e\fIn\fR'', where \fIn\fR is a digit
between 1 and 9, then it is replaced in the substitution with
the portion of \fIstring\fR that matched the \fIn\fR-th
parenthesized subexpression of \fIexp\fR.
Additional backslashes may be used in \fIsubSpec\fR to prevent special
interpretation of ``&'' or ``\e0'' or ``\e\fIn\fR'' or
backslash.
The use of backslashes in \fIsubSpec\fR tends to interact badly
with the Tcl parser's use of backslashes, so it's generally
safest to enclose \fIsubSpec\fR in braces if it includes
backslashes.
.LP
If the initial arguments to \fBregexp\fR start with \fB\-\fR then
.VS
they are treated as switches.  The following switches are
currently supported:
.TP 10
\fB\-all\fR
All ranges in \fIstring\fR that match \fIexp\fR are found and
substitution is performed for each of these ranges.
Without this switch only the first
matching range is found and substituted.
If \fB\-all\fR is specified, then ``&'' and ``\e\fIn\fR''
sequences are handled for each substitution using the information
from the corresponding match.
.TP 10
\fB\-nocase\fR
Upper-case characters in \fIstring\fR will be converted to lower-case
before matching against \fIexp\fR;  however, substitutions specified
by \fIsubSpec\fR use the original unconverted form of \fIstring\fR.
.TP 10
\fB\-\|\-\fR
Marks the end of switches.  The argument following this one will
be treated as \fIexp\fR even if it starts with a \fB\-.
.VE
.PP
See the manual entry for \fBregexp\fR for details on the interpretation
of regular expressions.

.SH KEYWORDS
match, pattern, regular expression, substitute
